<?php
/**
 * Piroll Plugins Activation
 *
 * @package Piroll
 */

require nk_admin()->admin_path . '/lib/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'piroll_register_required_plugins' );
if ( ! function_exists( 'piroll_register_required_plugins' ) ) :
    /**
     * Register Required Plugins.
     */
    function piroll_register_required_plugins() {

        /**
         * Array of plugin arrays. Required keys are name and slug.
         * If the source is NOT from the .org repo, then source is also required.
         */
        $plugins = array(

            // nK Themes Helper.
            array(
                'name'       => 'nK Themes Helper',
                'slug'       => 'nk-themes-helper',
                'source'     => 'https://a.nkdev.info/wp-plugins/nk-themes-helper.zip',
                'required'   => true,
            ),

            // Shortcodes.
            array(
                'name'       => 'Piroll Shortcodes',
                'slug'       => 'piroll-shortcodes',
                'version'    => '1.0.1',
                'source'     => 'https://a.nkdev.info/wp-plugins/piroll-shortcodes.zip',
                'required'   => true,
            ),

            // Visual Portfolio.
            array(
                'name'       => 'Visual Portfolio',
                'slug'       => 'visual-portfolio',
            ),

            // Visual Composer.
            array(
                'name'       => 'WPBakery Visual Composer',
                'slug'       => 'js_composer',
                'source'     => 'https://a.nkdev.info/wp-plugins/js_composer.zip',
                'required'   => true,
            ),

            // ACF PRO.
            array(
                'name'       => 'Advanced Custom Fields PRO',
                'slug'       => 'advanced-custom-fields-pro',
                'source'     => 'https://a.nkdev.info/wp-plugins/advanced-custom-fields-pro.zip',
                'required'   => true,
            ),

            // Kirki.
            array(
                'name'       => 'Kirki',
                'slug'       => 'kirki',
                'required'   => true,
            ),

            // AWB.
            array(
                'name'       => 'Advanced WordPress Backgrounds',
                'slug'       => 'advanced-backgrounds',
                'required'   => false,
            ),

            // Contact Form 7.
            array(
                'name'       => 'Contact Form 7',
                'slug'       => 'contact-form-7',
                'required'   => false,
            ),

            // WP Google Maps.
            array(
                'name'       => 'WP Google Maps',
                'slug'       => 'wp-google-maps',
                'required'   => false,
            ),
        );

        $config = array(
            'domain'           => 'piroll',
            'default_path'     => '',
            'has_notices'      => true,
            'message'          => '',
        );

        tgmpa( $plugins, $config );
    }
endif;


add_action( 'vc_before_init', 'piroll_vc_setastheme' );
if ( ! function_exists( 'piroll_vc_setastheme' ) ) :
    /**
     * Visual Composer as theme.
     */
    function piroll_vc_setastheme() {
        vc_set_as_theme();
    }
endif;
