<?php
// customize ACF
if ( ! function_exists( 'piroll_get_sidebars' ) ) :
    function piroll_get_sidebars() {
        global $wp_registered_sidebars;
        $sidebars = array(
            'default' => 'default',
        );

        foreach ( $wp_registered_sidebars as $k => $sidebar ) {
            $sidebars[ $sidebar['id'] ] = $sidebar['name'];
        }

        return $sidebars;
    }
endif;

if ( function_exists( 'acf_add_local_field_group' ) ) :
    add_action( 'init', 'piroll_acf_init' );
    if ( ! function_exists( 'piroll_acf_init' ) ) :
        function piroll_acf_init() {
            acf_add_local_field_group(
                array(
                    'key' => 'group_57f885759174a',
                    'title' => 'Additional Options',
                    'fields' => array(
                        array(
                            'placement' => 'left',
                            'endpoint' => 0,
                            'key' => 'field_58831c05c4899',
                            'label' => 'Navigation',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => 0,
                            'message' => '',
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                            'key' => 'field_58831c20c489a',
                            'label' => 'Custom',
                            'name' => 'post_navigation_custom',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831c6dc489b',
                            'label' => 'Show',
                            'name' => 'navigation_show',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d2ec489c',
                            'label' => 'Opaque',
                            'name' => 'navigation_opaque',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d52c489e',
                            'label' => 'Boxed',
                            'name' => 'navigation_boxed',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d52c489e1',
                            'label' => 'Dark',
                            'name' => 'navigation_dark',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d63c489f',
                            'label' => 'Large Height',
                            'name' => 'navigation_large',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d74c48a0',
                            'label' => 'Transparent',
                            'name' => 'navigation_transparent',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d82c48a1',
                            'label' => 'Transparent Always',
                            'name' => 'navigation_transparent_always',
                            'type' => 'select',
                            'instructions' => 'Transparent also after page scrolled',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d9ec48a2',
                            'label' => 'Sticky',
                            'name' => 'navigation_sticky',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831dafc48a3',
                            'label' => 'Hide on Scroll',
                            'name' => 'navigation_autohide',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_58831d9ec48a2',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831dcec48a5',
                            'label' => 'White Text on Top',
                            'name' => 'navigation_white_top_text',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'key' => 'field_57f886ae7c1e6',
                            'label' => 'Header',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'left',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_57fb333816f9c',
                            'label' => 'Custom',
                            'name' => 'post_header_custom',
                            'type' => 'checkbox',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'true' => 'true',
                            ),
                            'default_value' => array(),
                            'layout' => 'vertical',
                            'toggle' => 0,
                            'return_format' => 'value',
                        ),
                        array(
                            'key' => 'field_57f886dc7c1e7',
                            'label' => 'Show',
                            'name' => 'single_post_header_show',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f889b94ed76',
                            'label' => 'Size',
                            'name' => 'single_post_header_size',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'sm' => 'Small Size',
                                'md' => 'Mid Size',
                                'lg' => 'Large Size',
                                'xl' => 'X-Large Size',
                                'full' => 'Full Size',
                                'default' => 'default',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f88e563ad91',
                            'label' => 'Parallax for Background Image',
                            'name' => 'single_post_header_parallax',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f890953ad92',
                            'label' => 'Opacity Parallax for Image',
                            'name' => 'single_post_header_parallax_opacity',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f8923c3bd5b',
                            'label' => 'Type of Background Image',
                            'name' => 'single_post_header_type_image',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                0 => 'False',
                                'featured' => 'Featured',
                                'custom' => 'Custom',
                                'default' => 'default',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f897593e01a',
                            'label' => 'Background Image',
                            'name' => 'single_post_header_background_image',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5b',
                                        'operator' => '==',
                                        'value' => 'custom',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'url',
                            'preview_size' => 'full',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                        ),
                        array(
                            'key' => 'field_5806267feae01',
                            'label' => 'Overlay Color',
                            'name' => 'single_post_header_overlay',
                            'type' => 'color_picker',
                            'default_value' => 'rgba(255, 255, 255, 0.9)',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5b',
                                        'operator' => '==',
                                        'value' => 'custom',
                                    ),
                                    array(
                                        'field' => 'field_57f897593e01a',
                                        'operator' => '!=',
                                        'value' => '',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5b',
                                        'operator' => '==',
                                        'value' => 'featured',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'key' => 'field_5806267fefd01',
                            'label' => 'Custom Text Color',
                            'name' => 'single_post_header_color',
                            'type' => 'color_picker',
                            'default_value' => '',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                    ),
                    'location' => array(
                        array(
                            array(
                                'param' => 'post_type',
                                'operator' => '==',
                                'value' => 'post',
                            ),
                        ),
                    ),
                    'menu_order' => 0,
                    'position' => 'normal',
                    'style' => 'default',
                    'label_placement' => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen' => '',
                    'active' => 1,
                    'description' => '',
                )
            );

            acf_add_local_field_group(
                array(
                    'key' => 'group_page',
                    'title' => 'Additional Options',
                    'fields' => array(
                        array(
                            'placement' => 'left',
                            'endpoint' => 0,
                            'key' => 'field_58831e8a7846a',
                            'label' => 'Navigation',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => 0,
                            'message' => '',
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                            'key' => 'field_58831e8a7849d',
                            'label' => 'Custom',
                            'name' => 'page_navigation_custom',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a784d8',
                            'label' => 'Show',
                            'name' => 'navigation_show',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a784fe',
                            'label' => 'Opaque',
                            'name' => 'navigation_opaque',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a78533',
                            'label' => 'Boxed',
                            'name' => 'navigation_boxed',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a785331',
                            'label' => 'Dark',
                            'name' => 'navigation_dark',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a7854f',
                            'label' => 'Large Height',
                            'name' => 'navigation_large',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a78563',
                            'label' => 'Transparent',
                            'name' => 'navigation_transparent',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a78576',
                            'label' => 'Transparent Always',
                            'name' => 'navigation_transparent_always',
                            'type' => 'select',
                            'instructions' => 'Transparent also after page scrolled',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a78589',
                            'label' => 'Sticky',
                            'name' => 'navigation_sticky',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a785ad',
                            'label' => 'Hide on Scroll',
                            'name' => 'navigation_autohide',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a78589',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831e8a785db',
                            'label' => 'White Text on Top',
                            'name' => 'navigation_white_top_text',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831e8a7849d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831e8a784d8',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'key' => 'field_57f886ae7c1e6page',
                            'label' => 'Header',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'left',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_57fb333816f9cpage',
                            'label' => 'Custom',
                            'name' => 'page_header_custom',
                            'type' => 'checkbox',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'true' => 'true',
                            ),
                            'default_value' => array(),
                            'layout' => 'vertical',
                            'toggle' => 0,
                            'return_format' => 'value',
                        ),
                        array(
                            'key' => 'field_57f886dc7c1e7page',
                            'label' => 'Show',
                            'name' => 'single_page_header_show',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f889b94ed76page',
                            'label' => 'Size',
                            'name' => 'single_page_header_size',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'sm' => 'Small Size',
                                'md' => 'Mid Size',
                                'lg' => 'Large Size',
                                'xl' => 'X-Large Size',
                                'full' => 'Full Size',
                                'default' => 'default',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f88e563ad91page',
                            'label' => 'Parallax for Background Image',
                            'name' => 'single_page_header_parallax',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f890953ad92page',
                            'label' => 'Opacity Parallax for Image',
                            'name' => 'single_page_header_parallax_opacity',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f8923c3bd5bpage',
                            'label' => 'Type of Background Image',
                            'name' => 'single_page_header_type_image',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                0 => 'False',
                                'featured' => 'Featured',
                                'custom' => 'Custom',
                                'default' => 'default',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f897593e01apage',
                            'label' => 'Background Image',
                            'name' => 'single_page_header_background_image',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5bpage',
                                        'operator' => '==',
                                        'value' => 'custom',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'url',
                            'preview_size' => 'full',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                        ),
                        array(
                            'key' => 'field_58062a42eab8f',
                            'label' => 'Overlay Color',
                            'name' => 'single_page_header_overlay',
                            'type' => 'color_picker',
                            'default_value' => 'rgba(255, 255, 255, 0.9)',
                            'instructions' => 'Select opacity for Background Image',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5bpage',
                                        'operator' => '==',
                                        'value' => 'custom',
                                    ),
                                    array(
                                        'field' => 'field_57f897593e01apage',
                                        'operator' => '!=',
                                        'value' => '',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5bpage',
                                        'operator' => '==',
                                        'value' => 'featured',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'key' => 'field_57f8923g3as5bpage',
                            'label' => 'Custom Text Color',
                            'name' => 'single_page_header_color',
                            'type' => 'color_picker',
                            'default_value' => '',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'key' => 'field_57f8923c3as5bpage',
                            'label' => 'Show Title',
                            'name' => 'single_page_header_show_title',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                0 => 'False',
                                1 => 'Page Title',
                                'custom' => 'Custom',
                            ),
                            'default_value' => array(
                                0 => 1,
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57fb980a30bdf',
                            'label' => 'Title',
                            'name' => 'single_page_header_title',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3as5bpage',
                                        'operator' => '==',
                                        'value' => 'custom',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_57fb980d80bdf',
                            'label' => 'Sub Title',
                            'name' => 'single_page_header_sub_title',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_57fb982380be0',
                            'label' => 'Content',
                            'name' => 'single_page_header_content',
                            'type' => 'wysiwyg',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'tabs' => 'all',
                            'toolbar' => 'full',
                            'media_upload' => 1,
                        ),
                        array(
                            'key' => 'field_57fb984f80be1',
                            'label' => 'Video Link',
                            'name' => 'single_page_header_video_link',
                            'type' => 'url',
                            'instructions' => 'Supported YouTube and Vimeo links',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f890951ad92page',
                            'label' => 'Scroll Down Button',
                            'name' => 'single_page_header_scroll_down_button',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7page',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9cpage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57fb71db19a6dpage',
                            'label' => 'Content',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'left',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_57fb71ee19a6epage',
                            'label' => 'Custom',
                            'name' => 'content_page_custom',
                            'type' => 'checkbox',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'true' => 'true',
                            ),
                            'default_value' => array(),
                            'layout' => 'vertical',
                            'toggle' => 0,
                            'return_format' => 'value',
                        ),
                        array(
                            'key' => 'field_57fb720f19a6fpage',
                            'label' => 'Boxed',
                            'name' => 'single_page_boxed',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb71ee19a6epage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57fb92e788cee',
                            'label' => 'Show Title',
                            'name' => 'single_page_show_title',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb71ee19a6epage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_58077d2649bd3',
                            'label' => 'Top and Bottom paddings',
                            'name' => 'single_page_paddings',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb71ee19a6epage',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                0 => 'false',
                                'true' => 'true',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                    ),
                    'location' => array(
                        array(
                            array(
                                'param' => 'post_type',
                                'operator' => '==',
                                'value' => 'page',
                            ),
                        ),
                    ),
                    'menu_order' => 0,
                    'position' => 'normal',
                    'style' => 'default',
                    'label_placement' => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen' => '',
                    'active' => 1,
                    'description' => '',
                )
            );

            acf_add_local_field_group(
                array(
                    'key' => 'group_585ba31dbf314',
                    'title' => 'Portfolio',
                    'fields' => array(
                        array(
                            'placement' => 'left',
                            'endpoint' => 0,
                            'key' => 'field_585cca247beac',
                            'label' => 'Showcase',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'half' => 'Half',
                                'half_inverse' => 'Half Inverse',
                                'slider' => 'Slider',
                                'gallery' => 'Gallery',
                                'gallery_2' => 'Gallery Simple List',
                                'header' => 'Header',
                                'video' => 'Video',
                                'title' => 'Centered Title + Subtitle',
                            ),
                            'default_value' => array(
                                0 => 'half',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_585ba34ae79ac',
                            'label' => 'Style',
                            'name' => 'single_portfolio_style',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'library' => 'all',
                            'min' => '',
                            'max' => '',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'insert' => 'append',
                            'key' => 'field_585ba38ee79ad',
                            'label' => 'Gallery',
                            'name' => 'single_portfolio_gallery',
                            'type' => 'gallery',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'half',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'half_inverse',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'slider',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'gallery',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'gallery_2',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => 18000,
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => 'ms',
                            'key' => 'field_585bccedb85dd',
                            'label' => 'Slider Autoplay',
                            'name' => 'single_portfolio_slider_autoplay',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'slider',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => 1,
                            'message' => '',
                            'ui' => 1,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                            'key' => 'field_585bcd35b85de',
                            'label' => 'Slider Arrows',
                            'name' => 'single_portfolio_slider_arrows',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'slider',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'tabs' => 'all',
                            'toolbar' => 'full',
                            'media_upload' => 0,
                            'default_value' => '',
                            'delay' => 0,
                            'key' => 'field_585bf94eda629',
                            'label' => 'Header Text',
                            'name' => 'single_portfolio_header_text',
                            'type' => 'wysiwyg',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'header',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'return_format' => 'id',
                            'preview_size' => 'thumbnail',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'key' => 'field_585bf6dfda628',
                            'label' => 'Header Image',
                            'name' => 'single_portfolio_header_image',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'header',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => '',
                            'placeholder' => '',
                            'key' => 'field_585c17e845a09',
                            'label' => 'Video URL',
                            'name' => 'single_portfolio_video_url',
                            'type' => 'url',
                            'instructions' => 'Supported Youtube and Vimeo URLs',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'video',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'return_format' => 'id',
                            'preview_size' => 'thumbnail',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'key' => 'field_585c180b45a0a',
                            'label' => 'Video Thumbnail',
                            'name' => 'single_portfolio_video_thumbnail',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'video',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'tabs' => 'text',
                            'toolbar' => 'basic',
                            'media_upload' => 0,
                            'default_value' => '',
                            'delay' => 0,
                            'key' => 'field_585cd291df40f',
                            'label' => 'Subtitle',
                            'name' => 'single_portfolio_subtitle',
                            'type' => 'wysiwyg',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '==',
                                        'value' => 'title',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'placement' => 'left',
                            'endpoint' => 0,
                            'key' => 'field_585cca037beab',
                            'label' => 'Content',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'columns_1' => 'Columns',
                                'columns_2' => 'Columns Inverted',
                                'custom' => 'Custom Content Only',
                                'custom_no_gap' => 'Custom Content w/o Paddings',
                            ),
                            'default_value' => array(
                                0 => 'columns_1',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_585ccbab74843',
                            'label' => 'Style',
                            'name' => 'single_portfolio_content_style',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '!=',
                                        'value' => 'half',
                                    ),
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '!=',
                                        'value' => 'half_inverse',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'top' => 'Top',
                                'bottom' => 'Bottom',
                            ),
                            'default_value' => array(
                                0 => 'bottom',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_585cca9ef99d2',
                            'label' => 'Position',
                            'name' => 'single_portfolio_content_position',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '!=',
                                        'value' => 'half',
                                    ),
                                    array(
                                        'field' => 'field_585ba34ae79ac',
                                        'operator' => '!=',
                                        'value' => 'half_inverse',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => 1,
                            'message' => '',
                            'ui' => 1,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                            'key' => 'field_585cd01f26e0b',
                            'label' => 'Show Title',
                            'name' => 'single_portfolio_content_show_title',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'key' => 'field_585ba402e79ae',
                            'label' => 'Client',
                            'name' => 'single_portfolio_client',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ccbab74843',
                                        'operator' => '!=',
                                        'value' => 'custom',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'placement' => 'left',
                            'endpoint' => 0,
                            'key' => 'field_585ce2be74e5b',
                            'label' => 'Launch Site',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => 0,
                            'message' => '',
                            'ui' => 1,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                            'key' => 'field_585ce69a74e5d',
                            'label' => 'Enable',
                            'name' => 'single_portfolio_site_show',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => '',
                            'placeholder' => '',
                            'key' => 'field_585ce2cc74e5c',
                            'label' => 'Site URL',
                            'name' => 'single_portfolio_site_url',
                            'type' => 'url',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ce69a74e5d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => 1,
                            'message' => '',
                            'ui' => 1,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                            'key' => 'field_585ce6f674e5e',
                            'label' => 'Sharing Buttons',
                            'name' => 'single_portfolio_site_sharing',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_585ce69a74e5d',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                    ),
                    'location' => array(
                        array(
                            array(
                                'param' => 'post_type',
                                'operator' => '==',
                                'value' => 'portfolio',
                            ),
                        ),
                    ),
                    'menu_order' => 0,
                    'position' => 'acf_after_title',
                    'style' => 'default',
                    'label_placement' => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen' => '',
                    'active' => 1,
                    'description' => '',
                )
            );

            acf_add_local_field_group(
                array(
                    'key' => 'group_57f885759174a_pf',
                    'title' => 'Additional Options',
                    'fields' => array(
                        array(
                            'placement' => 'left',
                            'endpoint' => 0,
                            'key' => 'field_58831c05c4899_pf',
                            'label' => 'Navigation',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'default_value' => 0,
                            'message' => '',
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                            'key' => 'field_58831c20c489a_pf',
                            'label' => 'Custom',
                            'name' => 'portfolio_navigation_custom',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831c6dc489b_pf',
                            'label' => 'Show',
                            'name' => 'navigation_show',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d2ec489c_pf',
                            'label' => 'Opaque',
                            'name' => 'navigation_opaque',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d52c489e_pf',
                            'label' => 'Boxed',
                            'name' => 'navigation_boxed',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d52c489e1_pf',
                            'label' => 'Dark',
                            'name' => 'navigation_dark',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d63c489f_pf',
                            'label' => 'Large Height',
                            'name' => 'navigation_large',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d74c48a0_pf',
                            'label' => 'Transparent',
                            'name' => 'navigation_transparent',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d82c48a1_pf',
                            'label' => 'Transparent Always',
                            'name' => 'navigation_transparent_always',
                            'type' => 'select',
                            'instructions' => 'Transparent also after page scrolled',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831d9ec48a2_pf',
                            'label' => 'Sticky',
                            'name' => 'navigation_sticky',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831dafc48a3_pf',
                            'label' => 'Hide on Scroll',
                            'name' => 'navigation_autohide',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_58831d9ec48a2_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'multiple' => 0,
                            'allow_null' => 0,
                            'choices' => array(
                                'default' => 'Default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'return_format' => 'value',
                            'key' => 'field_58831dcec48a5_pf',
                            'label' => 'White Text on Top',
                            'name' => 'navigation_white_top_text',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_58831c20c489a_pf',
                                        'operator' => '==',
                                        'value' => '1',
                                    ),
                                    array(
                                        'field' => 'field_58831c6dc489b_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'key' => 'field_57f886ae7c1e6_pf',
                            'label' => 'Header',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'left',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_57fb333816f9c_pf',
                            'label' => 'Custom',
                            'name' => 'single_portfolio_header_custom',
                            'type' => 'checkbox',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'true' => 'true',
                            ),
                            'default_value' => array(),
                            'layout' => 'vertical',
                            'toggle' => 0,
                            'return_format' => 'value',
                        ),
                        array(
                            'key' => 'field_57f886dc7c1e7_pf',
                            'label' => 'Show',
                            'name' => 'single_portfolio_header_show',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f889b94ed76_pf',
                            'label' => 'Size',
                            'name' => 'single_portfolio_header_size',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'sm' => 'Small Size',
                                'md' => 'Mid Size',
                                'lg' => 'Large Size',
                                'xl' => 'X-Large Size',
                                'full' => 'Full Size',
                                'default' => 'default',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f88e563ad91_pf',
                            'label' => 'Parallax for Background Image',
                            'name' => 'single_portfolio_header_parallax',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f890953ad92_pf',
                            'label' => 'Opacity Parallax for Image',
                            'name' => 'single_portfolio_header_parallax_opacity',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f8923c3bd5b_pf',
                            'label' => 'Type of Background Image',
                            'name' => 'single_portfolio_header_type_image',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                0 => 'False',
                                'featured' => 'Featured',
                                'custom' => 'Custom',
                                'default' => 'default',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f897593e01a_pf',
                            'label' => 'Background Image',
                            'name' => 'single_portfolio_header_background_image',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5b_pf',
                                        'operator' => '==',
                                        'value' => 'custom',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'url',
                            'preview_size' => 'full',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                        ),
                        array(
                            'key' => 'field_5806267feae01_pf',
                            'label' => 'Overlay Color',
                            'name' => 'single_portfolio_header_overlay',
                            'type' => 'color_picker',
                            'default_value' => 'rgba(255, 255, 255, 0.9)',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5b_pf',
                                        'operator' => '==',
                                        'value' => 'custom',
                                    ),
                                    array(
                                        'field' => 'field_57f897593e01a_pf',
                                        'operator' => '!=',
                                        'value' => '',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3bd5b_pf',
                                        'operator' => '==',
                                        'value' => 'featured',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'key' => 'field_5806267fefd01_pf',
                            'label' => 'Custom Text Color',
                            'name' => 'single_portfolio_header_color',
                            'type' => 'color_picker',
                            'default_value' => '',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                        ),
                        array(
                            'key' => 'field_57f8923c3as5b_pf',
                            'label' => 'Show Title',
                            'name' => 'single_portfolio_header_show_title',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                0 => 'False',
                                1 => 'Page Title',
                                'custom' => 'Custom',
                            ),
                            'default_value' => array(
                                0 => 1,
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57fb980a30bdf_pf',
                            'label' => 'Title',
                            'name' => 'single_portfolio_header_title',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f8923c3as5b_pf',
                                        'operator' => '==',
                                        'value' => 'custom',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_57fb980d80bdf_pf',
                            'label' => 'Sub Title',
                            'name' => 'single_portfolio_header_sub_title',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_57fb982380be0_pf',
                            'label' => 'Content',
                            'name' => 'single_portfolio_header_content',
                            'type' => 'wysiwyg',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'tabs' => 'all',
                            'toolbar' => 'full',
                            'media_upload' => 1,
                        ),
                        array(
                            'key' => 'field_57fb984f80be1_pf',
                            'label' => 'Video Link',
                            'name' => 'single_portfolio_header_video_link',
                            'type' => 'url',
                            'instructions' => 'Supported YouTube and Vimeo links',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_57f890951ad92_pf',
                            'label' => 'Scroll Down Button',
                            'name' => 'single_portfolio_header_scroll_down_button',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_57f886dc7c1e7_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                    array(
                                        'field' => 'field_57fb333816f9c_pf',
                                        'operator' => '==',
                                        'value' => 'true',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'default' => 'default',
                                'true' => 'true',
                                0 => 'false',
                            ),
                            'default_value' => array(
                                0 => 'default',
                            ),
                            'allow_null' => 0,
                            'multiple' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                    ),
                    'location' => array(
                        array(
                            array(
                                'param' => 'post_type',
                                'operator' => '==',
                                'value' => 'portfolio',
                            ),
                        ),
                    ),
                    'menu_order' => 0,
                    'position' => 'normal',
                    'style' => 'default',
                    'label_placement' => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen' => '',
                    'active' => 1,
                    'description' => '',
                )
            );
        }
    endif;
endif;
