<?php
if ( ! function_exists( 'piroll_customize_register' ) ) :
    function piroll_customize_register( $wp_customize ) {
        $wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
        $wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
        $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
        $wp_customize->get_control( 'site_icon' )->priority = 10;

        $wp_customize->remove_control( 'display_header_text' );

        $wp_customize->get_section( 'title_tagline' )->title = 'General';
        $wp_customize->get_section( 'title_tagline' )->priority = 1;

        $wp_customize->remove_section( 'colors' );
        $wp_customize->remove_section( 'header_image' );
        $wp_customize->remove_section( 'background_image' );
    }
endif;
add_action( 'customize_register', 'piroll_customize_register' );


/**
 * Fix for body typography font Variants
 */
if ( ! function_exists( 'piroll_enqueue_body_font_variants' ) ) :
    function piroll_enqueue_body_font_variants( $fonts ) {
        $bodyFamily = piroll_get_theme_mod( 'typography_main_body' );
        $titlesFamily = piroll_get_theme_mod( 'typography_titles' );

        $bodyFamily = $bodyFamily['font-family'];
        $titlesFamily = $titlesFamily['font-family'];

        $fonts[ $bodyFamily ] = array(
            'regular',
            'italic',
            '500',
            '500italic',
        );
        $fonts[ $titlesFamily ] = array(
            'regular',
            '500',
            '500italic',
            'italic',
        );

        return $fonts;
    }
endif;
add_filter( 'kirki/enqueue_google_fonts', 'piroll_enqueue_body_font_variants' );


if ( ! function_exists( 'initial_kirki_options' ) && class_exists( 'NK_Options' ) ) {
    function initial_kirki_options() {
        NK_Options::add_config(
            array(
                'capability' => 'edit_theme_options',
                'option_type' => 'theme_mod',
            )
        );

        NK_Options::add_panel(
            'single_page', array(
                'priority' => 2,
                'title' => esc_html__( 'Single Page', 'piroll' ),
            )
        );
            NK_Options::add_section(
                'single_page_content', array(
                    'title' => esc_html__( 'Content', 'piroll' ),
                    'priority' => 1,
                    'panel' => 'single_page',
                )
            );
            NK_Options::add_section(
                'single_page_header', array(
                    'title' => esc_html__( 'Header', 'piroll' ),
                    'priority' => 2,
                    'panel' => 'single_page',
                )
            );

        NK_Options::add_panel(
            'single_post', array(
                'priority' => 3,
                'title' => esc_html__( 'Single Post', 'piroll' ),
                'icon' => '',
            )
        );
            NK_Options::add_section(
                'single_post_content', array(
                    'title' => esc_html__( 'Content', 'piroll' ),
                    'priority' => 1,
                    'panel' => 'single_post',
                )
            );
            NK_Options::add_section(
                'single_post_header', array(
                    'title' => esc_html__( 'Header', 'piroll' ),
                    'priority' => 2,
                    'panel' => 'single_post',
                )
            );

        NK_Options::add_panel(
            'archive', array(
                'priority' => 4,
                'title' => esc_html__( 'Archive', 'piroll' ),
                'icon' => '',
            )
        );
            NK_Options::add_section(
                'archive_content', array(
                    'title' => esc_html__( 'Content', 'piroll' ),
                    'priority' => 1,
                    'panel' => 'archive',
                )
            );
            NK_Options::add_section(
                'archive_header', array(
                    'title' => esc_html__( 'Header', 'piroll' ),
                    'priority' => 2,
                    'panel' => 'archive',
                )
            );

        NK_Options::add_panel(
            'single_portfolio', array(
                'priority' => 5,
                'title' => esc_html__( 'Single Portfolio Item', 'piroll' ),
                'icon' => '',
            )
        );
            NK_Options::add_section(
                'single_portfolio_content', array(
                    'title' => esc_html__( 'Content', 'piroll' ),
                    'priority' => 1,
                    'panel' => 'single_portfolio',
                )
            );
            NK_Options::add_section(
                'single_portfolio_header', array(
                    'title' => esc_html__( 'Header', 'piroll' ),
                    'priority' => 2,
                    'panel' => 'single_portfolio',
                )
            );

        NK_Options::add_panel(
            'search', array(
                'priority' => 7,
                'title' => esc_html__( 'Search', 'piroll' ),
                'icon' => '',
            )
        );
            NK_Options::add_section(
                'search_content', array(
                    'title' => esc_html__( 'Content', 'piroll' ),
                    'priority' => 1,
                    'panel' => 'search',
                )
            );
            NK_Options::add_section(
                'search_header', array(
                    'title' => esc_html__( 'Header', 'piroll' ),
                    'priority' => 2,
                    'panel' => 'search',
                )
            );

        NK_Options::add_section(
            'not_found_page', array(
                'title' => esc_html__( '404 Page', 'piroll' ),
                'priority' => 8,
            )
        );

        NK_Options::add_panel(
            'navigation', array(
                'priority' => 9,
                'title' => esc_html__( 'Navigation', 'piroll' ),
                'icon' => 'fa fa-bars',
            )
        );
            NK_Options::add_section(
                'navigation_general', array(
                    'title' => esc_html__( 'General', 'piroll' ),
                    'priority' => 1,
                    'panel' => 'navigation',
                )
            );
            NK_Options::add_section(
                'navigation_logo', array(
                    'title' => esc_html__( 'Logo', 'piroll' ),
                    'priority' => 2,
                    'panel' => 'navigation',
                )
            );
            NK_Options::add_section(
                'navigation_nav', array(
                    'title' => esc_html__( 'Navigation Main Style', 'piroll' ),
                    'priority' => 3,
                    'panel' => 'navigation',
                )
            );
            NK_Options::add_section(
                'navigation_fullscreen', array(
                    'title' => esc_html__( 'Navigation Fullscreen Style', 'piroll' ),
                    'priority' => 4,
                    'panel' => 'navigation',
                )
            );

        NK_Options::add_section(
            'style', array(
                'title' => esc_html__( 'Styles', 'piroll' ),
                'priority' => 10,
                'icon' => 'fa fa-paint-brush',
            )
        );

        NK_Options::add_section(
            'typography', array(
                'title' => esc_html__( 'Typography', 'piroll' ),
                'priority' => 11,
                'icon' => 'fa fa-font',
            )
        );

        NK_Options::add_section(
            'footer', array(
                'title' => esc_html__( 'Footer', 'piroll' ),
                'priority' => 12,
                'icon' => 'fa fa-hand-o-down',
            )
        );

        NK_Options::add_section(
            'sharing', array(
                'title' => esc_html__( 'Sharing Buttons', 'piroll' ),
                'priority' => 13,
                'icon' => 'fa fa-share-alt',
            )
        );

        /**
         * Single page
         * */
        // Header
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_page_header_show',
                'label' => esc_html__( 'Show', 'piroll' ),
                'section' => 'single_page_header',
                'default' => 'off',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'single_page_header_size',
                'label' => esc_html__( 'Size', 'piroll' ),
                'section' => 'single_page_header',
                'default' => 'md',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'sm' => esc_attr__( 'Small Size', 'piroll' ),
                    'md' => esc_attr__( 'Mid Size', 'piroll' ),
                    'lg' => esc_attr__( 'Large Size', 'piroll' ),
                    'xl' => esc_attr__( 'X-Large Size', 'piroll' ),
                    'full' => esc_attr__( 'Full Size', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_page_header_parallax',
                'label' => esc_html__( 'Parallax for Background Image', 'piroll' ),
                'section' => 'single_page_header',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_page_header_parallax_opacity',
                'label' => esc_html__( 'Opacity Parallax for Image', 'piroll' ),
                'section' => 'single_page_header',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'single_page_header_type_image',
                'label' => esc_html__( 'Select Type of Background Image', 'piroll' ),
                'section' => 'single_page_header',
                'default' => 'custom',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_attr__( 'Disabled', 'piroll' ),
                    'featured' => esc_attr__( 'Featured', 'piroll' ),
                    'custom' => esc_attr__( 'Custom', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'single_page_header_background_image',
                'label' => esc_html__( 'Background Image', 'piroll' ),
                'section' => 'single_page_header',
                'default' => get_template_directory_uri() . '/assets/images/banner-bg.jpg',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                    array(
                        'setting' => 'single_page_header_type_image',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'single_page_header_overlay',
                'label'       => esc_attr__( 'Overlay Color', 'piroll' ),
                'section'     => 'single_page_header',
                'default'     => '',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'single_page_header_color',
                'label'       => esc_attr__( 'Custom Text Color', 'piroll' ),
                'section'     => 'single_page_header',
                'default'     => '',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_page_header_sub_title',
                'label' => esc_html__( 'Sub Title', 'piroll' ),
                'section' => 'single_page_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'editor',
                'settings' => 'single_page_header_content',
                'label' => esc_html__( 'Content', 'piroll' ),
                'section' => 'single_page_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_page_header_video_link',
                'label' => esc_html__( 'Video Link', 'piroll' ),
                'section' => 'single_page_header',
                'default' => '',
                'description' => esc_html__( 'Supported YouTube and Vimeo video link', 'piroll' ),
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_page_header_scroll_down_button',
                'label' => esc_html__( 'Scroll Down Button', 'piroll' ),
                'section' => 'single_page_header',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_page_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        // Content
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_page_show_title',
                'label' => esc_html__( 'Show Title', 'piroll' ),
                'section' => 'single_page_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_page_boxed',
                'label' => esc_html__( 'Boxed', 'piroll' ),
                'section' => 'single_page_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_page_paddings',
                'label' => esc_html__( 'Top and Bottom paddings', 'piroll' ),
                'section' => 'single_page_content',
                'default' => 'on',
                'priority' => 10,
            )
        );

        /**
         * Single post
         * */
        // Content
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_post_show_title',
                'label' => esc_html__( 'Title', 'piroll' ),
                'section' => 'single_post_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_post_show_prev_next',
                'label' => esc_html__( 'Show Prev and Next posts links', 'piroll' ),
                'section' => 'single_post_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_post_archive_url',
                'label' => esc_html__( 'Posts List Page URL', 'piroll' ),
                'section' => 'single_post_content',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_show_prev_next',
                        'operator' => '==',
                        'value' => 1,
                    ),
                ),
            )
        );
        // Header
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_post_header_show',
                'label' => esc_html__( 'Show', 'piroll' ),
                'section' => 'single_post_header',
                'default' => 'off',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'single_post_header_size',
                'label' => esc_html__( 'Size', 'piroll' ),
                'section' => 'single_post_header',
                'default' => 'md',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'sm' => esc_attr__( 'Small Size', 'piroll' ),
                    'md' => esc_attr__( 'Mid Size', 'piroll' ),
                    'lg' => esc_attr__( 'Large Size', 'piroll' ),
                    'xl' => esc_attr__( 'X-Large Size', 'piroll' ),
                    'full' => esc_attr__( 'Full Size', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_post_header_parallax',
                'label' => esc_html__( 'Parallax for Background Image', 'piroll' ),
                'section' => 'single_post_header',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_post_header_parallax_opacity',
                'label' => esc_html__( 'Opacity Parallax for Image', 'piroll' ),
                'section' => 'single_post_header',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'single_post_header_type_image',
                'label' => esc_html__( 'Select Type of Background Image', 'piroll' ),
                'section' => 'single_post_header',
                'default' => 'featured',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_attr__( 'Disabled', 'piroll' ),
                    'featured' => esc_attr__( 'Featured', 'piroll' ),
                    'custom' => esc_attr__( 'Custom', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'single_post_header_background_image',
                'label' => esc_html__( 'Background Image', 'piroll' ),
                'section' => 'single_post_header',
                'default' => get_template_directory_uri() . '/assets/images/banner-bg.jpg',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                    array(
                        'setting' => 'single_post_header_type_image',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'single_post_header_overlay',
                'label'       => esc_attr__( 'Overlay Color', 'piroll' ),
                'section'     => 'single_post_header',
                'default'     => '',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'single_post_header_color',
                'label'       => esc_attr__( 'Custom Text Color', 'piroll' ),
                'section'     => 'single_post_header',
                'default'     => '',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'single_post_header_title_type',
                'label' => esc_html__( 'Title Type', 'piroll' ),
                'section' => 'single_post_header',
                'default' => 'title',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_attr__( 'Disabled', 'piroll' ),
                    'title' => esc_attr__( 'Post Title', 'piroll' ),
                    'custom' => esc_attr__( 'Custom', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_post_header_title',
                'label' => esc_html__( 'Title', 'piroll' ),
                'section' => 'single_post_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                    array(
                        'setting' => 'single_post_header_title_type',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_post_header_sub_title',
                'label' => esc_html__( 'Sub Title', 'piroll' ),
                'section' => 'single_post_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'editor',
                'settings' => 'single_post_header_content',
                'label' => esc_html__( 'Content', 'piroll' ),
                'section' => 'single_post_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_post_header_video_link',
                'label' => esc_html__( 'Video Link', 'piroll' ),
                'section' => 'single_post_header',
                'default' => '',
                'description' => esc_html__( 'Supported YouTube and Vimeo video link', 'piroll' ),
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_post_header_scroll_down_button',
                'label' => esc_html__( 'Scroll Down Button', 'piroll' ),
                'section' => 'single_post_header',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_post_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );

        /**
         * Archive page
         */
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'archive_boxed',
                'label' => esc_html__( 'Boxed', 'piroll' ),
                'section' => 'archive_content',
                'default' => 'default',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_html__( 'Disabled', 'piroll' ),
                    'default' => esc_html__( 'Default', 'piroll' ),
                    'small' => esc_html__( 'Small', 'piroll' ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'archive_show_title',
                'label' => esc_html__( 'Show Title', 'piroll' ),
                'section' => 'archive_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'archive_show_filter',
                'label' => esc_html__( 'Show Filter', 'piroll' ),
                'section' => 'archive_content',
                'default' => 'off',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'archive_filter_opened',
                'label' => esc_html__( 'Filter Opened', 'piroll' ),
                'section' => 'archive_content',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'archive_show_filter',
                        'operator' => '==',
                        'value' => 1,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'archive_list_style',
                'label' => esc_html__( 'List Style', 'piroll' ),
                'section' => 'archive_content',
                'default' => 'masonry_3',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'masonry_1' => esc_html__( 'Masonry 1 Column', 'piroll' ),
                    'masonry_2' => esc_html__( 'Masonry 2 Column', 'piroll' ),
                    'masonry_3' => esc_html__( 'Masonry 3 Column', 'piroll' ),
                    'tile_1' => esc_html__( 'Tile 1 Column', 'piroll' ),
                    'tile_2' => esc_html__( 'Tile 2 Column', 'piroll' ),
                    'tile_3' => esc_html__( 'Tile 3 Column', 'piroll' ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'archive_posts_content',
                'label' => esc_html__( 'Posts Content Type', 'piroll' ),
                'section' => 'archive_content',
                'default' => 'excerpt',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_html__( 'Disabled', 'piroll' ),
                    'excerpt' => esc_html__( 'Excerpt', 'piroll' ),
                    'more' => esc_html__( 'Use more tag', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'archive_list_style',
                        'operator' => 'contains',
                        'value' => 'masonry',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'archive_posts_content_excerpt_count',
                'label' => esc_html__( 'Posts Content Words Count', 'piroll' ),
                'section' => 'archive_content',
                'default' => 15,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'archive_list_style',
                        'operator' => 'contains',
                        'value' => 'masonry',
                    ),
                    array(
                        'setting' => 'archive_posts_content',
                        'operator' => '==',
                        'value' => 'excerpt',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'archive_pagination',
                'label' => esc_html__( 'Pagination', 'piroll' ),
                'section' => 'archive_content',
                'default' => 'load_more',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_html__( 'No Pagination', 'piroll' ),
                    true => esc_html__( 'Simple Pagination', 'piroll' ),
                    'load_more' => esc_html__( 'Load More button', 'piroll' ),
                    'infinite' => esc_html__( 'Infinite Scroll', 'piroll' ),
                ),
            )
        );
        // Header
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'archive_header_show',
                'label' => esc_html__( 'Show', 'piroll' ),
                'section' => 'archive_header',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'archive_header_size',
                'label' => esc_html__( 'Size', 'piroll' ),
                'section' => 'archive_header',
                'default' => 'md',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'sm' => esc_attr__( 'Small Size', 'piroll' ),
                    'md' => esc_attr__( 'Mid Size', 'piroll' ),
                    'lg' => esc_attr__( 'Large Size', 'piroll' ),
                    'xl' => esc_attr__( 'X-Large Size', 'piroll' ),
                    'full' => esc_attr__( 'Full Size', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'archive_header_parallax',
                'label' => esc_html__( 'Parallax for Background Image', 'piroll' ),
                'section' => 'archive_header',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'archive_header_parallax_opacity',
                'label' => esc_html__( 'Opacity Parallax for Image', 'piroll' ),
                'section' => 'archive_header',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'archive_header_background_image',
                'label' => esc_html__( 'Background Image', 'piroll' ),
                'section' => 'archive_header',
                'default' => get_template_directory_uri() . '/assets/images/banner-bg.jpg',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'archive_header_overlay',
                'label'       => esc_attr__( 'Overlay Color', 'piroll' ),
                'section'     => 'archive_header',
                'default'     => 'rgba(255, 255, 255, 0.9)',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'archive_header_color',
                'label'       => esc_attr__( 'Custom Text Color', 'piroll' ),
                'section'     => 'archive_header',
                'default'     => '',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'archive_header_sub_title',
                'label' => esc_html__( 'Sub Title', 'piroll' ),
                'section' => 'archive_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'editor',
                'settings' => 'archive_header_content',
                'label' => esc_html__( 'Content', 'piroll' ),
                'section' => 'archive_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'archive_header_video_link',
                'label' => esc_html__( 'Video Link', 'piroll' ),
                'section' => 'archive_header',
                'description' => esc_html__( 'Supported YouTube and Vimeo video link', 'piroll' ),
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'archive_header_scroll_down_button',
                'label' => esc_html__( 'Scroll Down Button', 'piroll' ),
                'section' => 'archive_header',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'archive_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );

        /**
         * Single Portfolio Item
         */
        // content
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_portfolio_show_prev_next',
                'label' => esc_html__( 'Show Prev and Next items links', 'piroll' ),
                'section' => 'single_portfolio_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_portfolio_archive_url',
                'label' => esc_html__( 'Portfolio List Page URL', 'piroll' ),
                'section' => 'single_portfolio_content',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_show_prev_next',
                        'operator' => '==',
                        'value' => 1,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_portfolio_show_date',
                'label' => esc_html__( 'Show Date', 'piroll' ),
                'section' => 'single_portfolio_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_portfolio_show_share',
                'label' => esc_html__( 'Show Share Buttons', 'piroll' ),
                'section' => 'single_portfolio_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        // Header
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_portfolio_header_show',
                'label' => esc_html__( 'Show', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => 'off',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'single_portfolio_header_size',
                'label' => esc_html__( 'Size', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => 'md',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'sm' => esc_attr__( 'Small Size', 'piroll' ),
                    'md' => esc_attr__( 'Mid Size', 'piroll' ),
                    'lg' => esc_attr__( 'Large Size', 'piroll' ),
                    'xl' => esc_attr__( 'X-Large Size', 'piroll' ),
                    'full' => esc_attr__( 'Full Size', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_portfolio_header_parallax',
                'label' => esc_html__( 'Parallax for Background Image', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_portfolio_header_parallax_opacity',
                'label' => esc_html__( 'Opacity Parallax for Image', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'single_portfolio_header_type_image',
                'label' => esc_html__( 'Select Type of Background Image', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => 'featured',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_attr__( 'Disabled', 'piroll' ),
                    'featured' => esc_attr__( 'Featured', 'piroll' ),
                    'custom' => esc_attr__( 'Custom', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'single_portfolio_header_background_image',
                'label' => esc_html__( 'Background Image', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => get_template_directory_uri() . '/assets/images/banner-bg.jpg',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                    array(
                        'setting' => 'single_portfolio_header_type_image',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'single_portfolio_header_overlay',
                'label'       => esc_attr__( 'Overlay Color', 'piroll' ),
                'section'     => 'single_portfolio_header',
                'default'     => '',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'single_portfolio_header_color',
                'label'       => esc_attr__( 'Custom Text Color', 'piroll' ),
                'section'     => 'single_portfolio_header',
                'default'     => '',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'single_portfolio_header_title_type',
                'label' => esc_html__( 'Title Type', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => 'title',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_attr__( 'Disabled', 'piroll' ),
                    'title' => esc_attr__( 'Post Title', 'piroll' ),
                    'custom' => esc_attr__( 'Custom', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_portfolio_header_title',
                'label' => esc_html__( 'Title', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                    array(
                        'setting' => 'single_portfolio_header_title_type',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_portfolio_header_sub_title',
                'label' => esc_html__( 'Sub Title', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'editor',
                'settings' => 'single_portfolio_header_content',
                'label' => esc_html__( 'Content', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'single_portfolio_header_video_link',
                'label' => esc_html__( 'Video Link', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => '',
                'description' => esc_html__( 'Supported YouTube and Vimeo video link', 'piroll' ),
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'single_portfolio_header_scroll_down_button',
                'label' => esc_html__( 'Scroll Down Button', 'piroll' ),
                'section' => 'single_portfolio_header',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'single_portfolio_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );

        /**
         * Search page
         */
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'search_boxed',
                'label' => esc_html__( 'Boxed', 'piroll' ),
                'section' => 'search_content',
                'default' => 'default',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_html__( 'Disabled', 'piroll' ),
                    'default' => esc_html__( 'Default', 'piroll' ),
                    'small' => esc_html__( 'Small', 'piroll' ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'search_show_title',
                'label' => esc_html__( 'Show Title', 'piroll' ),
                'section' => 'search_content',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'search_show_filter',
                'label' => esc_html__( 'Show Filter', 'piroll' ),
                'section' => 'search_content',
                'default' => 'off',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'search_filter_opened',
                'label' => esc_html__( 'Filter Opened', 'piroll' ),
                'section' => 'search_content',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'search_show_filter',
                        'operator' => '==',
                        'value' => 1,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'search_list_style',
                'label' => esc_html__( 'List Style', 'piroll' ),
                'section' => 'search_content',
                'default' => 'masonry_3',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'masonry_1' => esc_html__( 'Masonry 1 Column', 'piroll' ),
                    'masonry_2' => esc_html__( 'Masonry 2 Column', 'piroll' ),
                    'masonry_3' => esc_html__( 'Masonry 3 Column', 'piroll' ),
                    'tile_1' => esc_html__( 'Tile 1 Column', 'piroll' ),
                    'tile_2' => esc_html__( 'Tile 2 Column', 'piroll' ),
                    'tile_3' => esc_html__( 'Tile 3 Column', 'piroll' ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'search_posts_content',
                'label' => esc_html__( 'Posts Content Type', 'piroll' ),
                'section' => 'search_content',
                'default' => 'excerpt',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_html__( 'Disabled', 'piroll' ),
                    'excerpt' => esc_html__( 'Excerpt', 'piroll' ),
                    'more' => esc_html__( 'Use more tag', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'search_list_style',
                        'operator' => 'contains',
                        'value' => 'masonry',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'search_posts_content_excerpt_count',
                'label' => esc_html__( 'Posts Content Words Count', 'piroll' ),
                'section' => 'search_content',
                'default' => 15,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'search_list_style',
                        'operator' => 'contains',
                        'value' => 'masonry',
                    ),
                    array(
                        'setting' => 'search_posts_content',
                        'operator' => '==',
                        'value' => 'excerpt',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'search_pagination',
                'label' => esc_html__( 'Pagination', 'piroll' ),
                'section' => 'search_content',
                'default' => 'load_more',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    false => esc_html__( 'No Pagination', 'piroll' ),
                    true => esc_html__( 'Simple Pagination', 'piroll' ),
                    'load_more' => esc_html__( 'Load More button', 'piroll' ),
                    'infinite' => esc_html__( 'Infinite Scroll', 'piroll' ),
                ),
            )
        );
        // Header
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'search_header_show',
                'label' => esc_html__( 'Show', 'piroll' ),
                'section' => 'search_header',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'search_header_size',
                'label' => esc_html__( 'Size', 'piroll' ),
                'section' => 'search_header',
                'default' => 'md',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'sm' => esc_attr__( 'Small Size', 'piroll' ),
                    'md' => esc_attr__( 'Mid Size', 'piroll' ),
                    'lg' => esc_attr__( 'Large Size', 'piroll' ),
                    'xl' => esc_attr__( 'X-Large Size', 'piroll' ),
                    'full' => esc_attr__( 'Full Size', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'search_header_parallax',
                'label' => esc_html__( 'Parallax for Background Image', 'piroll' ),
                'section' => 'search_header',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'search_header_parallax_opacity',
                'label' => esc_html__( 'Opacity Parallax for Image', 'piroll' ),
                'section' => 'search_header',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'search_header_background_image',
                'label' => esc_html__( 'Background Image', 'piroll' ),
                'section' => 'search_header',
                'default' => get_template_directory_uri() . '/assets/images/banner-bg.jpg',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'search_header_overlay',
                'label'       => esc_attr__( 'Overlay Color', 'piroll' ),
                'section'     => 'search_header',
                'default'     => 'rgba(255, 255, 255, 0.9)',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type'        => 'color',
                'settings'    => 'search_header_color',
                'label'       => esc_attr__( 'Custom Text Color', 'piroll' ),
                'section'     => 'search_header',
                'default'     => '',
                'priority'    => 10,
                'choices'     => array(
                    'alpha'       => true,
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),

                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'search_header_sub_title',
                'label' => esc_html__( 'Sub Title', 'piroll' ),
                'section' => 'search_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'editor',
                'settings' => 'search_header_content',
                'label' => esc_html__( 'Content', 'piroll' ),
                'section' => 'search_header',
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'text',
                'settings' => 'search_header_video_link',
                'label' => esc_html__( 'Video Link', 'piroll' ),
                'section' => 'search_header',
                'description' => esc_html__( 'Supported YouTube and Vimeo video link', 'piroll' ),
                'default' => '',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'search_header_scroll_down_button',
                'label' => esc_html__( 'Scroll Down Button', 'piroll' ),
                'section' => 'search_header',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'search_header_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );

        /**
         * Not Found page
         */
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'not_found_show_text',
                'label' => esc_html__( 'Show Text', 'piroll' ),
                'section' => 'not_found_page',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'not_found_show_search',
                'label' => esc_html__( 'Show Search', 'piroll' ),
                'section' => 'not_found_page',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'not_found_show_home_button',
                'label' => esc_html__( 'Show Home Button', 'piroll' ),
                'section' => 'not_found_page',
                'default' => 'off',
                'priority' => 10,
            )
        );

        /**
         * Navigation
         */
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_show',
                'label' => esc_html__( 'Show', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'on',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_opaque',
                'label' => esc_html__( 'Opaque', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_boxed',
                'label' => esc_html__( 'Boxed', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'on',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_dark',
                'label' => esc_html__( 'Dark', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_large',
                'label' => esc_html__( 'Large Height', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_transparent',
                'label' => esc_html__( 'Transparent', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_transparent_always',
                'label' => esc_html__( 'Transparent Always', 'piroll' ),
                'description' => esc_html__( 'Transparent also after page scrolled', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_sticky',
                'label' => esc_html__( 'Sticky', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_autohide',
                'label' => esc_html__( 'Hide on Scroll', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                    array(
                        'setting' => 'navigation_sticky',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'toggle',
                'settings' => 'navigation_white_top_text',
                'label' => esc_html__( 'White Text on Top', 'piroll' ),
                'section' => 'navigation_general',
                'default' => 'off',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        // Logo
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'navigation_logo',
                'label' => esc_html__( 'Logo', 'piroll' ),
                'section' => 'navigation_logo',
                'default' => get_template_directory_uri() . '/assets/images/logo.svg',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'navigation_logo_light',
                'label' => esc_html__( 'Logo Light', 'piroll' ),
                'section' => 'navigation_logo',
                'default' => get_template_directory_uri() . '/assets/images/logo-light.svg',
                'priority' => 10,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'navigation_logo_width',
                'label' => esc_html__( 'Logo width', 'piroll' ),
                'section' => 'navigation_logo',
                'default' => 31,
                'choices' => array(
                    'min' => '50',
                    'max' => '400',
                    'step' => '1',
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_logo',
                        'operator' => '!=',
                        'value' => '',
                    ),
                    array(
                        'setting' => 'navigation_show',
                        'operator' => '==',
                        'value' => true,
                    ),
                ),
            )
        );
        // Navigation
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'navigation_type',
                'label' => esc_html__( 'Type', 'piroll' ),
                'section' => 'navigation_nav',
                'default' => 'default',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'default' => esc_attr__( 'Default', 'piroll' ),
                    'split' => esc_attr__( 'Split', 'piroll' ),
                    'fullscreen' => esc_attr__( 'Fullscreen', 'piroll' ),
                ),
            )
        );
        $menu_name = 'primary';
        $menu_array = array(
            false => esc_html__( 'Not Use', 'piroll' ),
        );
        $locations = get_nav_menu_locations();
        if ( is_array( $locations ) && isset( $locations ) && ! empty( $locations ) && array_key_exists( $menu_name, $locations ) ) {
            $menu_items = wp_get_nav_menu_items( wp_get_nav_menu_object( $locations[ $menu_name ] ) );
            if ( is_array( $menu_items ) && isset( $menu_items ) && ! empty( $menu_items ) ) {
                foreach ( $menu_items as $menu_item ) {
                    if ( $menu_item->menu_item_parent == 0 && $menu_item->post_status == 'publish' ) {
                        $menu_array[ $menu_item->ID ] = $menu_item->title;
                    }
                }
            }
        }
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'navigation_split_logo_position',
                'label' => esc_html__( 'Logo position after menu item:', 'piroll' ),
                'section' => 'navigation_nav',
                'default' => false,
                'priority' => 10,
                'multiple' => 0,
                'choices' => $menu_array,
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_type',
                        'operator' => '==',
                        'value' => 'split',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'navigation_default_align',
                'label' => esc_html__( 'Align', 'piroll' ),
                'section' => 'navigation_nav',
                'default' => 'right',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'center' => esc_attr__( 'Center', 'piroll' ),
                    'right' => esc_attr__( 'Right', 'piroll' ),
                    'left' => esc_attr__( 'Left', 'piroll' ),
                ),
                'active_callback' => array(
                    array(
                        'setting' => 'navigation_type',
                        'operator' => '!=',
                        'value' => 'fullscreen',
                    ),
                ),
            )
        );

        /**
         * Fullscreen Navigation
         */
        NK_Options::add_field(
            array(
                'type' => 'select',
                'settings' => 'navigation_fullscreen_align',
                'label' => esc_html__( 'Align', 'piroll' ),
                'section' => 'navigation_fullscreen',
                'default' => 'center',
                'priority' => 10,
                'multiple' => 0,
                'choices' => array(
                    'center' => esc_attr__( 'Center', 'piroll' ),
                    'right' => esc_attr__( 'Right', 'piroll' ),
                    'left' => esc_attr__( 'Left', 'piroll' ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'navigation_fullscreen_background_image',
                'label' => esc_html__( 'Background Image', 'piroll' ),
                'section' => 'navigation_fullscreen',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'repeater',
                'label' => esc_html__( 'Social Links', 'piroll' ),
                'section' => 'navigation_fullscreen',
                'priority' => 10,
                'settings' => 'navigation_fullscreen_social',
                'default' => array(
                    array(
                        'soc_class' => 'fa fa-twitter',
                        'link_url' => '#',
                    ),
                    array(
                        'soc_class' => 'fa fa-dribbble',
                        'link_url' => '#',
                    ),
                    array(
                        'soc_class' => 'fa fa-instagram',
                        'link_url' => '#',
                    ),
                    array(
                        'soc_class' => 'fa fa-pinterest',
                        'link_url' => '#',
                    ),
                ),
                'fields' => array(
                    'soc_class' => array(
                        'type' => 'select',
                        'label' => esc_html__( 'Website', 'piroll' ),
                        'default' => 'fa fa-facebook',
                        'priority' => 10,
                        'choices' => piroll_get_social_list(),
                    ),
                    'link_url' => array(
                        'type' => 'text',
                        'label' => esc_attr__( 'Link URL', 'piroll' ),
                        'default' => '',
                    ),
                ),
            )
        );

        /**
         * Typography
         */
        NK_Options::add_field(
            array(
                'type' => 'typography',
                'settings' => 'typography_main_body',
                'label' => esc_attr__( 'Body', 'piroll' ),
                'section' => 'typography',
                'default' => array(
                    'font-family' => 'Nunito Sans',
                    'line-height' => '1.65',
                ),
                'priority' => 10,
                'output' => array(
                    array(
                        'element' => 'body',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'typography',
                'settings' => 'typography_html',
                'label' => esc_attr__( 'HTML', 'piroll' ),
                'section' => 'typography',
                'default' => array(
                    'font-size' => '15px',
                ),
                'priority' => 10,
                'output' => array(
                    array(
                        'element' => 'html',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'typography',
                'settings' => 'typography_titles',
                'label' => esc_attr__( 'Main Titles', 'piroll' ),
                'section' => 'typography',
                'default' => array(
                    'font-family' => 'Montserrat',
                    'variant' => '500',
                ),
                'priority' => 10,
                'output' => array(
                    array(
                        'element' => '.nk-heading-font, h1, .h1, h2, .h2, h3, .h3, h4, .h4, h5, .h5, h6, .h6, .display-1, .display-2, .display-3, .display-4, .nk-carousel .nk-carousel-prev .nk-carousel-arrow-name, .nk-carousel .nk-carousel-next .nk-carousel-arrow-name, .nk-carousel-3 .nk-carousel-prev .nk-carousel-arrow-name, .nk-carousel-3 .nk-carousel-next .nk-carousel-arrow-name, .nk-navbar, .nk-navbar-full .nk-nav > li:last-of-type > a, .nk-navbar-full .nk-nav > li > a, .nk-navbar-full .nk-nav .dropdown > li:last-of-type > a, .nk-navbar-full .nk-nav .dropdown > li > a',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'typography',
                'settings' => 'typography_additional',
                'label' => esc_attr__( 'Additional Items', 'piroll' ),
                'section' => 'typography',
                'default' => array(
                    'font-family' => 'Montserrat',
                    'variant' => '500',
                ),
                'priority' => 10,
                'output' => array(
                    array(
                        'element' => '.nk-post-meta, .nk-comments .nk-comment .nk-comment-meta, blockquote.nk-blockquote-style-1, .nk-btn-2, .nk-ibox-1 .nk-ibox-text, .nk-ibox-title, .nk-pagination > a, .nk-pagination .container > a, .nk-progress .nk-progress-title, .nk-tabs .nav-tabs .nav-link, .nk-fullpage-portfolio .nk-fullpage-nav > li, .nk-fullpage-portfolio .nk-fullpage-item-category a, .nk-isotope-filter > li, .nk-portfolio-list .nk-portfolio-item .portfolio-item-category, .nk-portfolio-launch-site, div.lead, .vp-filter__style-default .vp-filter__item > *, .vp-pagination__style-default .vp-pagination__item > *, .vp-portfolio__items .vp-portfolio__item-meta .vp-portfolio__item-meta-categories .vp-portfolio__item-meta-category',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'typography',
                'settings' => 'typography_buttons',
                'label' => esc_attr__( 'Buttons', 'piroll' ),
                'section' => 'typography',
                'default' => array(
                    'font-family' => 'Montserrat',
                    'variant' => '500',
                ),
                'priority' => 10,
                'output' => array(
                    array(
                        'element' => '.nk-btn',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_h1',
                'label' => esc_attr__( 'H1 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 37.5,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => 'h1, .h1',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_h2',
                'label' => esc_attr__( 'H2 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 30,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => 'h2, .h2',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_h3',
                'label' => esc_attr__( 'H3 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 25.35,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => 'h3, .h3',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_h4',
                'label' => esc_attr__( 'H4 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 21,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => 'h4, .h4',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_h5',
                'label' => esc_attr__( 'H5 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 18.75,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => 'h5, .h5',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_h6',
                'label' => esc_attr__( 'H6 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 15,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => 'h6, .h6',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_display1',
                'label' => esc_attr__( 'Display 1 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 61.5,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => '.display-1',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_display2',
                'label' => esc_attr__( 'Display 2 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 54,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => '.display-2',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_display3',
                'label' => esc_attr__( 'Display 3 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 51,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => '.display-3',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_titles_display4',
                'label' => esc_attr__( 'Display 4 Titles', 'piroll' ),
                'section' => 'typography',
                'default' => 39,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => '.display-4',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'typography_subtitles',
                'label' => esc_attr__( 'Subtitles', 'piroll' ),
                'section' => 'typography',
                'default' => 13.95,
                'priority' => 10,
                'choices' => array(
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ),
                'output' => array(
                    array(
                        'element' => '.nk-subtitle',
                        'property' => 'font-size',
                        'units' => 'px',
                    ),
                ),
                'transport' => 'auto',
            )
        );

        /**
         * Footer
         */
        NK_Options::add_field(
            array(
                'type' => 'image',
                'settings' => 'footer_bg_image',
                'label' => esc_html__( 'Background Image', 'piroll' ),
                'section' => 'footer',
                'default' => '',
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'footer_bg_image_opacity',
                'label' => esc_html__( 'Background Image Opacity', 'piroll' ),
                'section' => 'footer',
                'default' => 1,
                'choices'     => array(
                    'min'  => 0,
                    'max'  => 1,
                    'step' => 0.01,
                ),
                'priority' => 10,
                'output' => array(
                    array(
                        'element' => '.nk-footer .bg-image',
                        'property' => 'opacity',
                    ),
                ),
                'transport' => 'auto',
                'active_callback' => array(
                    array(
                        'setting' => 'footer_bg_image',
                        'operator' => '!=',
                        'value' => '',
                    ),
                ),
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'color',
                'settings' => 'footer_bg_color',
                'label' => esc_html__( 'Background Color', 'piroll' ),
                'section' => 'footer',
                'default' => '#ebebeb',
                'priority' => 10,
                'output' => array(
                    array(
                        'element' => '.nk-footer',
                        'property' => 'background-color',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'color',
                'settings' => 'footer_text_color',
                'label' => esc_html__( 'Text Color', 'piroll' ),
                'section' => 'footer',
                'default' => '#5f5f5f',
                'priority' => 10,
                'output' => array(
                    array(
                        'element' => '.nk-footer, .nk-footer .nk-widget-title',
                        'property' => 'color',
                    ),
                ),
                'transport' => 'auto',
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'footer_widget_1_size',
                'label' => esc_attr__( 'Widget 1 Size', 'piroll' ),
                'section' => 'footer',
                'default' => 4,
                'choices'     => array(
                    'min'  => '0',
                    'max'  => '12',
                    'step' => '1',
                ),
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'footer_widget_2_size',
                'label' => esc_attr__( 'Widget 2 Size', 'piroll' ),
                'section' => 'footer',
                'default' => 4,
                'choices'     => array(
                    'min'  => '0',
                    'max'  => '12',
                    'step' => '1',
                ),
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'footer_widget_3_size',
                'label' => esc_attr__( 'Widget 3 Size', 'piroll' ),
                'section' => 'footer',
                'default' => 4,
                'choices'     => array(
                    'min'  => '0',
                    'max'  => '12',
                    'step' => '1',
                ),
                'priority' => 10,
            )
        );
        NK_Options::add_field(
            array(
                'type' => 'slider',
                'settings' => 'footer_widget_4_size',
                'label' => esc_attr__( 'Widget 4 Size', 'piroll' ),
                'section' => 'footer',
                'default' => 0,
                'choices'     => array(
                    'min'  => '0',
                    'max'  => '12',
                    'step' => '1',
                ),
                'priority' => 10,
            )
        );

        /**
         * Sharing
         */
        NK_Options::add_field(
            array(
                'type' => 'repeater',
                'label' => esc_html__( 'Sharing', 'piroll' ),
                'description' => esc_html__( 'Sharing buttons for single blog and portfolio pages.', 'piroll' ),
                'section' => 'sharing',
                'priority' => 10,
                'settings' => 'sharing_links',
                'default' => array(
                    array(
                        'soc_class' => 'fa fa-facebook',
                    ),
                    array(
                        'soc_class' => 'fa fa-twitter',
                    ),
                    array(
                        'soc_class' => 'fa fa-google-plus',
                    ),
                ),
                'fields' => array(
                    'soc_class' => array(
                        'type' => 'select',
                        'label' => esc_html__( 'Website', 'piroll' ),
                        'priority' => 10,
                        'choices' => piroll_get_social_list( 'small' ),
                    ),
                ),
            )
        );

        /**
         * Style Compiler
         */
        $custom_style = function_exists( 'nk_theme' );
        if ( ! $custom_style ) {
            NK_Options::add_field(
                array(
                    'type' => 'custom',
                    'settings' => 'style_message_without_nk_themes_helper',
                    'label' => esc_html__( 'Required Plugin', 'piroll' ),
                    'description' => esc_html__( 'To generate custom styles you should install nK Themes Helper Plugin', 'piroll' ),
                    'section' => 'style',
                    'priority' => 10,
                )
            );
        } elseif ( version_compare( phpversion(), '5.4', '<' ) ) {
            NK_Options::add_field(
                array(
                    'type' => 'custom',
                    'settings' => 'style_message_without_php',
                    'label' => esc_html__( 'Required PHP version 5.4 or higher', 'piroll' ),
                    'section' => 'style',
                    'priority' => 10,
                )
            );
        } else {

            NK_Options::add_field(
                array(
                    'type' => 'toggle',
                    'settings' => 'style_custom',
                    'label' => esc_html__( 'Enable Custom Styles', 'piroll' ),
                    'section' => 'style',
                    'default' => 'off',
                    'priority' => 10,
                )
            );

            // main colors
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_main',
                    'label' => esc_html__( 'Main Color', 'piroll' ),
                    'section' => 'style',
                    'default' => '#10c9c3',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_text',
                    'label' => esc_html__( 'Color Text', 'piroll' ),
                    'section' => 'style',
                    'default' => '#5f5f5f',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_text_blog',
                    'label' => esc_html__( 'Color Text Blog', 'piroll' ),
                    'section' => 'style',
                    'default' => '#787878',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_titles',
                    'label' => esc_html__( 'Color Titles', 'piroll' ),
                    'section' => 'style',
                    'default' => '#171717',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_bg',
                    'label' => esc_html__( 'Color Background', 'piroll' ),
                    'section' => 'style',
                    'default' => '#f6f6f6',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_bg_footer',
                    'label' => esc_html__( 'Color Background Footer', 'piroll' ),
                    'section' => 'style',
                    'default' => '#141414',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_text_footer',
                    'label' => esc_html__( 'Color Text Footer', 'piroll' ),
                    'section' => 'style',
                    'default' => '#bcbcbc',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_titles_footer',
                    'label' => esc_html__( 'Color Titles Footer', 'piroll' ),
                    'section' => 'style',
                    'default' => '#ffffff',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_dark',
                    'label' => esc_html__( 'Color Dark', 'piroll' ),
                    'section' => 'style',
                    'default' => '#252525',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            NK_Options::add_field(
                array(
                    'type' => 'color',
                    'settings' => 'style_color_gray',
                    'label' => esc_html__( 'Color Gray', 'piroll' ),
                    'section' => 'style',
                    'default' => '#FAFAFA',
                    'priority' => 10,
                    'required' => array(
                        array(
                            'setting' => 'style_custom',
                            'operator' => '==',
                            'value' => 1,
                        ),
                    ),
                )
            );
            add_action( 'customize_preview_init', 'piroll_compile_colors' );
            add_action( 'customize_save_after', 'piroll_compile_colors' );
            if ( ! function_exists( 'piroll_compile_colors' ) ) :
                function piroll_compile_colors() {
                    if ( ! piroll_get_theme_mod( 'style_custom' ) ) {
                        return;
                    }

                    $file_scss = get_template_directory() . '/assets/scss/';

                    $variables_scss = '
                        @import "_variables.scss";

                        $color_main: ' . piroll_get_theme_mod( 'style_color_main' ) . ';

                        $color_text: ' . piroll_get_theme_mod( 'style_color_text' ) . ';
                        $color_text_blog: ' . piroll_get_theme_mod( 'style_color_text_blog' ) . ';
                        $color_titles: ' . piroll_get_theme_mod( 'style_color_titles' ) . ';
                        $color_bg: ' . piroll_get_theme_mod( 'style_color_bg' ) . ';
                        $color_bg_footer: ' . piroll_get_theme_mod( 'style_color_bg_footer' ) . ';
                        $color_text_footer: ' . piroll_get_theme_mod( 'style_color_text_footer' ) . ';
                        $color_titles_footer: ' . piroll_get_theme_mod( 'style_color_titles_footer' ) . ';

                        // dark colors
                        $color_dark_1: ' . piroll_get_theme_mod( 'style_color_dark' ) . ';
                        $color_dark_2: lighten($color_dark_1, 4%);
                        $color_dark_3: lighten($color_dark_1, 8%);
                        $color_dark_4: lighten($color_dark_1, 12%);

                        // black colors
                        $color_black_1: #000;
                        $color_black_2: #0e0e0e;
                        $color_black_3: #141414;

                        // gray colors
                        $color_gray_1: ' . piroll_get_theme_mod( 'style_color_gray' ) . ';
                        $color_gray_2: darken($color_gray_1, 1%);
                        $color_gray_3: darken($color_gray_1, 2%);
                        $color_gray_4: darken($color_gray_1, 3%);
                        $color_gray_5: darken($color_gray_1, 20%);

                        // main colors list
                        $colors: (
                            "main"  : $color_main,
                            "white"   : #fff,
                            "black"   : $color_black_1,
                            "black-2" : $color_black_2,
                            "black-3" : $color_black_3,
                            "dark-1"  : $color_dark_1,
                            "dark-2"  : $color_dark_2,
                            "dark-3"  : $color_dark_3,
                            "dark-4"  : $color_dark_4,
                            "gray-1"  : $color_gray_1,
                            "gray-2"  : $color_gray_2,
                            "gray-3"  : $color_gray_3,
                            "gray-4"  : $color_gray_4,
                            "gray-5"  : $color_gray_5
                        );

                        @import "_includes.scss"';

                    // compile styles
                    nk_theme()->scss( 'piroll-custom.min.css', $file_scss, $variables_scss );
                }
            endif;
        }
    }

    add_action( 'init', 'initial_kirki_options' );
}
if ( ! function_exists( 'piroll_get_theme_mod' ) ) {
    function piroll_get_theme_mod( $name = null, $use_acf = null, $postId = null, $acf_name = null ) {
        $value = null;

        if ( $name == null ) {
            return $value;
        }

        // try get value from meta box
        if ( $use_acf ) {
            $value = piroll_get_metabox( $acf_name ? $acf_name : $name, $postId );
        }

        // get value from options
        if ( ( $value == null || $value === 'default' ) ) {
            if ( class_exists( 'NK_Options' ) ) {
                $value = NK_Options::get_option( $name );
            }
        }

        $value = apply_filters( 'piroll_filter_get_theme_mod', $value, $name );
        return $value;
    }
}

// get metabox
if ( ! function_exists( 'piroll_get_metabox' ) ) :
    function piroll_get_metabox( $name = null, $postId = null ) {
        $value = null;

        // try get value from meta box
        if ( function_exists( 'get_field' ) ) {
            if ( $postId == null ) {
                $postId = get_the_ID();
            }
            $value = get_field( $name, $postId );
        }

        return $value;
    }
endif;
