/*!
 * Name    : Video Worker (wrapper for Youtube, Vimeo and Local videos)
 * Version : 1.2.1
 * Author  : _nK https://nkdev.info
 * GitHub  : https://github.com/nk-o/jarallax
 */
!function(e){"use strict";function t(e){e=e||{};for(var t=1;t<arguments.length;t++)if(arguments[t])for(var i in arguments[t])arguments[t].hasOwnProperty(i)&&(e[i]=arguments[t][i]);return e}function i(){this._done=[],this._fail=[]}function o(e,t,i){e.addEventListener?e.addEventListener(t,i):e.attachEvent("on"+t,function(){i.call(e)})}i.prototype={execute:function(e,t){var i=e.length;for(t=Array.prototype.slice.call(t);i--;)e[i].apply(null,t)},resolve:function(){this.execute(this._done,arguments)},reject:function(){this.execute(this._fail,arguments)},done:function(e){this._done.push(e)},fail:function(e){this._fail.push(e)}};var a=function(){function e(e,o){var a=this;a.url=e,a.options_default={autoplay:1,loop:1,mute:1,controls:0,startTime:0,endTime:0},a.options=t({},a.options_default,o),a.videoID=a.parseURL(e),a.videoID&&(a.ID=i++,a.loadAPI(),a.init())}var i=0;return e}();a.prototype.parseURL=function(e){function t(e){var t=/.*(?:youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=)([^#\&\?]*).*/,i=e.match(t);return!(!i||11!==i[1].length)&&i[1]}function i(e){var t=/https?:\/\/(?:www\.|player\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/([^\/]*)\/videos\/|album\/(\d+)\/video\/|video\/|)(\d+)(?:$|\/|\?)/,i=e.match(t);return!(!i||!i[3])&&i[3]}function o(e){for(var t=e.split(/,(?=mp4\:|webm\:|ogv\:|ogg\:)/),i={},o=0,a=0;a<t.length;a++){var n=t[a].match(/^(mp4|webm|ogv|ogg)\:(.*)/);n&&n[1]&&n[2]&&(i["ogv"===n[1]?"ogg":n[1]]=n[2],o=1)}return!!o&&i}var a=t(e),n=i(e),r=o(e);return a?(this.type="youtube",a):n?(this.type="vimeo",n):!!r&&(this.type="local",r)},a.prototype.isValid=function(){return!!this.videoID},a.prototype.on=function(e,t){this.userEventsList=this.userEventsList||[],(this.userEventsList[e]||(this.userEventsList[e]=[])).push(t)},a.prototype.off=function(e,t){if(this.userEventsList&&this.userEventsList[e])if(t)for(var i=0;i<this.userEventsList[e].length;i++)this.userEventsList[e][i]===t&&(this.userEventsList[e][i]=!1);else delete this.userEventsList[e]},a.prototype.fire=function(e){var t=[].slice.call(arguments,1);if(this.userEventsList&&"undefined"!=typeof this.userEventsList[e])for(var i in this.userEventsList[e])this.userEventsList[e][i]&&this.userEventsList[e][i].apply(this,t)},a.prototype.play=function(e){var t=this;t.player&&("youtube"===t.type&&t.player.playVideo&&("undefined"!=typeof e&&t.player.seekTo(e||0),t.player.playVideo()),"vimeo"===t.type&&("undefined"!=typeof e&&t.player.setCurrentTime(e),t.player.getPaused().then(function(e){e&&t.player.play()})),"local"===t.type&&("undefined"!=typeof e&&(t.player.currentTime=e),t.player.play()))},a.prototype.pause=function(){this.player&&("youtube"===this.type&&this.player.pauseVideo&&this.player.pauseVideo(),"vimeo"===this.type&&this.player.pause(),"local"===this.type&&this.player.pause())},a.prototype.getImageURL=function(e){var t=this;if(t.videoImage)return void e(t.videoImage);if("youtube"===t.type){var i=["maxresdefault","sddefault","hqdefault","0"],o=0,a=new Image;a.onload=function(){120!==(this.naturalWidth||this.width)||o===i.length-1?(t.videoImage="https://img.youtube.com/vi/"+t.videoID+"/"+i[o]+".jpg",e(t.videoImage)):(o++,this.src="https://img.youtube.com/vi/"+t.videoID+"/"+i[o]+".jpg")},a.src="https://img.youtube.com/vi/"+t.videoID+"/"+i[o]+".jpg"}if("vimeo"===t.type){var n=new XMLHttpRequest;n.open("GET","https://vimeo.com/api/v2/video/"+t.videoID+".json",!0),n.onreadystatechange=function(){if(4===this.readyState&&this.status>=200&&this.status<400){var i=JSON.parse(this.responseText);t.videoImage=i[0].thumbnail_large,e(t.videoImage)}},n.send(),n=null}},a.prototype.getIframe=function(t){var i=this;return i.$iframe?void t(i.$iframe):void i.onAPIready(function(){function a(e,t,i){var o=document.createElement("source");o.src=t,o.type=i,e.appendChild(o)}var n;if(i.$iframe||(n=document.createElement("div"),n.style.display="none"),"youtube"===i.type){i.playerOptions={},i.playerOptions.videoId=i.videoID,i.playerOptions.playerVars={autohide:1,rel:0,autoplay:0},i.options.controls||(i.playerOptions.playerVars.iv_load_policy=3,i.playerOptions.playerVars.modestbranding=1,i.playerOptions.playerVars.controls=0,i.playerOptions.playerVars.showinfo=0,i.playerOptions.playerVars.disablekb=1);var r,p;i.playerOptions.events={onReady:function(e){i.options.mute&&e.target.mute(),i.options.autoplay&&i.play(i.options.startTime),i.fire("ready",e)},onStateChange:function(e){i.options.loop&&e.data===YT.PlayerState.ENDED&&i.play(i.options.startTime),r||e.data!==YT.PlayerState.PLAYING||(r=1,i.fire("started",e)),e.data===YT.PlayerState.PLAYING&&i.fire("play",e),e.data===YT.PlayerState.PAUSED&&i.fire("pause",e),e.data===YT.PlayerState.ENDED&&i.fire("end",e),i.options.endTime&&(e.data===YT.PlayerState.PLAYING?p=setInterval(function(){i.options.endTime&&i.player.getCurrentTime()>=i.options.endTime&&(i.options.loop?i.play(i.options.startTime):i.pause())},150):clearInterval(p))}};var s=!i.$iframe;if(s){var l=document.createElement("div");l.setAttribute("id",i.playerID),n.appendChild(l),document.body.appendChild(n)}i.player=i.player||new e.YT.Player(i.playerID,i.playerOptions),s&&(i.$iframe=document.getElementById(i.playerID),i.videoWidth=parseInt(i.$iframe.getAttribute("width"),10)||1280,i.videoHeight=parseInt(i.$iframe.getAttribute("height"),10)||720)}if("vimeo"===i.type){i.playerOptions="",i.playerOptions+="player_id="+i.playerID,i.playerOptions+="&autopause=0",i.options.controls||(i.playerOptions+="&badge=0&byline=0&portrait=0&title=0"),i.playerOptions+="&autoplay="+(i.options.autoplay?"1":"0"),i.playerOptions+="&loop="+(i.options.loop?1:0),i.$iframe||(i.$iframe=document.createElement("iframe"),i.$iframe.setAttribute("id",i.playerID),i.$iframe.setAttribute("src","https://player.vimeo.com/video/"+i.videoID+"?"+i.playerOptions),i.$iframe.setAttribute("frameborder","0"),n.appendChild(i.$iframe),document.body.appendChild(n)),i.player=i.player||new Vimeo.Player(i.$iframe),i.player.getVideoWidth().then(function(e){i.videoWidth=e||1280}),i.player.getVideoHeight().then(function(e){i.videoHeight=e||720}),i.player.setVolume(i.options.mute?0:100);var d;i.player.on("timeupdate",function(e){d||i.fire("started",e),d=1,i.options.endTime&&i.options.endTime&&e.seconds>=i.options.endTime&&(i.options.loop?i.play(i.options.startTime):i.pause())}),i.player.on("play",function(e){i.fire("play",e),i.options.startTime&&0===e.seconds&&i.play(i.options.startTime)}),i.player.on("pause",function(e){i.fire("pause",e)}),i.player.on("ended",function(e){i.fire("end",e)}),i.player.on("loaded",function(e){i.fire("ready",e)})}if("local"===i.type){if(!i.$iframe){i.$iframe=document.createElement("video"),i.options.mute&&(i.$iframe.muted=!0),i.options.loop&&(i.$iframe.loop=!0),i.$iframe.setAttribute("id",i.playerID),n.appendChild(i.$iframe),document.body.appendChild(n);for(var u in i.videoID)a(i.$iframe,i.videoID[u],"video/"+u)}i.player=i.player||i.$iframe;var y;o(i.player,"playing",function(e){y||i.fire("started",e),y=1}),o(i.player,"timeupdate",function(){i.options.endTime&&i.options.endTime&&this.currentTime>=i.options.endTime&&(i.options.loop?i.play(i.options.startTime):i.pause())}),o(i.player,"play",function(e){i.fire("play",e)}),o(i.player,"pause",function(e){i.fire("pause",e)}),o(i.player,"ended",function(e){i.fire("end",e)}),o(i.player,"loadedmetadata",function(){i.videoWidth=this.videoWidth||1280,i.videoHeight=this.videoHeight||720,i.fire("ready"),i.options.autoplay&&i.play(i.options.startTime)})}t(i.$iframe)})},a.prototype.init=function(){var e=this;e.playerID="VideoWorker-"+e.ID};var n=0,r=0;a.prototype.loadAPI=function(){var t=this;if(!n||!r){var i="";if("youtube"!==t.type||n||(n=1,i="//www.youtube.com/iframe_api"),"vimeo"!==t.type||r||(r=1,i="//player.vimeo.com/api/player.js"),i){"file://"===e.location.origin&&(i="http:"+i);var o=document.createElement("script"),a=document.getElementsByTagName("head")[0];o.src=i,a.appendChild(o),a=null,o=null}}};var p=0,s=0,l=new i,d=new i;a.prototype.onAPIready=function(t){var i=this;if("youtube"===i.type&&("undefined"!=typeof YT&&0!==YT.loaded||p?"object"==typeof YT&&1===YT.loaded?t():l.done(function(){t()}):(p=1,e.onYouTubeIframeAPIReady=function(){e.onYouTubeIframeAPIReady=null,l.resolve("done"),t()})),"vimeo"===i.type)if("undefined"!=typeof Vimeo||s)"undefined"!=typeof Vimeo?t():d.done(function(){t()});else{s=1;var o=setInterval(function(){"undefined"!=typeof Vimeo&&(clearInterval(o),d.resolve("done"),t())},20)}"local"===i.type&&t()},e.VideoWorker=a}(window),/*!
 * Name    : Video Background Extension for Jarallax
 * Version : 1.0.0
 * Author  : _nK http://nkdev.info
 * GitHub  : https://github.com/nk-o/jarallax
 */
function(){"use strict";if("undefined"!=typeof jarallax){var e=jarallax.constructor,t=e.prototype.init;e.prototype.init=function(){var e=this;t.apply(e),e.video&&e.video.getIframe(function(t){var i=t.parentNode;e.css(t,{position:"fixed",top:"0px",left:"0px",right:"0px",bottom:"0px",width:"100%",height:"100%",maxWidth:"none",maxHeight:"none",visibility:"visible",margin:0,zIndex:-1}),e.$video=t,e.image.$container.appendChild(t),i.parentNode.removeChild(i)})};var i=e.prototype.coverImage;e.prototype.coverImage=function(){var e=this;i.apply(e),e.video&&"IFRAME"===e.image.$item.nodeName&&e.css(e.image.$item,{height:e.image.$item.getBoundingClientRect().height+400+"px",marginTop:-200+parseFloat(e.css(e.image.$item,"margin-top"))+"px"})};var o=e.prototype.initImg;e.prototype.initImg=function(){var e=this,t=o.apply(e);if(e.options.videoSrc||(e.options.videoSrc=e.$item.getAttribute("data-jarallax-video")||!1),e.options.videoSrc){var i=new VideoWorker(e.options.videoSrc,{startTime:e.options.videoStartTime||0,endTime:e.options.videoEndTime||0});if(i.isValid()&&(e.image.useImgTag=!0,i.on("ready",function(){var t=e.onScroll;e.onScroll=function(){t.apply(e),e.isVisible()?i.play():i.pause()}}),i.on("started",function(){e.image.$default_item=e.image.$item,e.image.$item=e.$video,e.image.width=e.options.imgWidth=e.video.videoWidth||1280,e.image.height=e.options.imgHeight=e.video.videoHeight||720,e.coverImage(),e.clipContainer(),e.onScroll(),e.image.$default_item&&(e.image.$default_item.style.display="none")}),e.video=i,"local"!==i.type&&i.getImageURL(function(t){e.image.src=t,e.init()})),"local"!==i.type)return!1;if(!t)return e.image.src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",!0}return t};var a=e.prototype.destroy;e.prototype.destroy=function(){var e=this;a.apply(e)}}}();