<?php
/**
 * The template for displaying comments.
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Piroll
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}
?>


<div id="comments"></div>
<div class="nk-comments">
    <?php
    // You can start editing here -- including this comment!
    if ( have_comments() ) :
        ?>

        <div class="nk-gap-3"></div>
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <h3 class="nk-title">
                        <?php echo esc_html__( 'Comments:', 'piroll' ); ?>
                    </h3>
                    <div class="nk-gap-1"></div>

                    <?php
                    wp_list_comments(
                        array(
                            'walker' => new piroll_walker_comment(),
                            'short_ping' => true,
                            'avatar_size' => 200,
                            'max_depth' => 4,
                        )
                    );
                    ?>
                    <!-- .comment-list -->

                    <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
                        <div class="nk-gap-2"></div>
                        <nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
                            <h2 class="sr-only"><?php esc_html_e( 'Comment navigation', 'piroll' ); ?></h2>
                            <?php
                            $page = get_query_var( 'cpage' );
                            ?>
                            <?php if ( isset( $page ) ) : ?>
                                <div class="nk-pagination ">
                                    <?php
                                    previous_comments_link(
                                        '<span
                                    class="nk-icon-arrow-left"></span>' . esc_html__( 'Older Comments', 'piroll' )
                                    );
                                    ?>
                                    <?php
                                    next_comments_link(
                                        esc_html__( 'Newer Comments', 'piroll' ) . '<span
                                    class="nk-icon-arrow-right"></span>'
                                    );
                                    ?>
                                </div><!-- .nav-links -->
                            <?php endif; ?>
                        </nav><!-- #comment-nav-below -->
                        <?php
                    endif; // Check for comment navigation.
                    ?>
                </div>
            </div>
        </div>
        <div class="nk-gap-3"></div>

    <?php endif; // Check for have_comments(). ?>
</div>

<div class="nk-reply">
    <div class="nk-gap-3"></div>
    <div class="container">
        <div class="row">
            <div class="col-lg-8 offset-lg-2">
                <?php

                // If comments are closed and there are comments, let's leave a little note, shall we?
                if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
                    ?>

                    <p class="no-comments mb-0"><?php esc_html_e( 'Comments are closed.', 'piroll' ); ?></p>
                    <?php
                endif;
                $commenter = wp_get_current_commenter();
                $required_fields = array(
                    'email' => array(
                        'req_class' => get_option( 'require_name_email' ) ? ' required' : '',
                        'req_placeholder' => get_option( 'require_name_email' ) ? ' *' : '',
                    ),
                    'author' => array(
                        'req_class' => get_option( 'require_name_author' ) ? ' required' : '',
                        'req_placeholder' => get_option( 'require_name_author' ) ? ' *' : '',
                    ),
                    'url' => array(
                        'req_class' => get_option( 'require_name_url' ) ? ' required' : '',
                        'req_placeholder' => get_option( 'require_name_url' ) ? ' *' : '',
                    ),
                );

                comment_form(
                    array(
                        'title_reply' => '<h3 id="reply-title" class="nk-title">' . esc_html__( 'Leave a Comment:', 'piroll' ) . '<small><a rel="nofollow" id="cancel-comment-reply-link" href="#respond" style="display:none;"> ' . esc_html__( 'Cancel reply', 'piroll' ) . '</a></small></h3> <div class="nk-gap-1"></div>',
                        'comment_notes_before' => '',
                        'fields' => array(
                            'email' => '<div class="row vertical-gap">
                                        <div class="col-md-4">
                                            <input type="email" class="' . esc_attr( 'form-control' . $required_fields['email']['req_class'] ) . '" name="email"
                                                   placeholder="' . esc_html__( 'Your Email', 'piroll' ) . $required_fields['email']['req_placeholder'] . '" value="' . esc_attr( $commenter['comment_author_email'] ) .
                                                               '">
                                        </div>',
                            'author' => '<div class="col-md-4">
                                        <input type="text" class="' . esc_attr( 'form-control' . $required_fields['author']['req_class'] ) . '" name="author"
                                               placeholder="' . esc_html__( 'Your Name', 'piroll' ) . $required_fields['author']['req_placeholder'] . '" value="' . esc_attr( $commenter['comment_author'] ) .
                                                            '">
                                    </div>',
                            'url' => '<div class="col-md-4">
                                        <input type="url" class="' . esc_attr( 'form-control' . $required_fields['url']['req_class'] ) . '" name="url" placeholder="' . esc_html__( 'Your Website', 'piroll' ) . $required_fields['url']['req_placeholder'] . '" value="' . esc_attr( $commenter['comment_author_url'] ) .
                                     '">
                                    </div>
                                </div>',
                        ),
                        'class_submit' => 'hidden button',
                        'class_form' => 'nk-form nk-form-style-1',
                        'comment_field' => '<div class="nk-gap-1"></div>
                                            <textarea class="form-control required" name="comment" rows="5" placeholder="' . esc_html__( 'Comment', 'piroll' ) . ' *" aria-required="true"></textarea>
                                        <div class="nk-gap-1"></div>
                                        <div class="nk-form-response-success"></div>
                                        <div class="nk-form-response-error"></div>',
                        'comment_notes_after' => '<button type="submit" class="nk-btn">' . esc_html__( 'Post a Comment', 'piroll' ) . '</button>',
                    )
                );

                ?>
            </div>
        </div>
    </div>
    <div class="nk-gap-3"></div>
</div>
