<!-- START: Footer -->
<?php
$footer_bg_image = piroll_get_theme_mod( 'footer_bg_image' );

$show_footer_1 = piroll_get_theme_mod( 'footer_widget_1_size' ) && is_active_sidebar( 'footer-1' );
$show_footer_2 = piroll_get_theme_mod( 'footer_widget_2_size' ) && is_active_sidebar( 'footer-2' );
$show_footer_3 = piroll_get_theme_mod( 'footer_widget_3_size' ) && is_active_sidebar( 'footer-3' );
$show_footer_4 = piroll_get_theme_mod( 'footer_widget_4_size' ) && is_active_sidebar( 'footer-3' );

if ( $show_footer_1 || $show_footer_2 || $show_footer_3 || $show_footer_4 ) :
    ?>

    <footer class="nk-footer">
        <?php
        if ( $footer_bg_image ) :
            $footer_bg_image = piroll_get_attachment( $footer_bg_image, '1920x1080' );
            ?>
            <div class="bg-image" style="background-image: url('<?php echo esc_url( $footer_bg_image['src'] ); ?>');"></div>
        <?php endif; ?>

        <div class="container">
            <div class="row vertical-gap">
                <?php if ( $show_footer_1 ) : ?>
                    <div class="col-lg-<?php echo esc_attr( piroll_get_theme_mod( 'footer_widget_1_size' ) ); ?>">
                        <?php dynamic_sidebar( 'footer-1' ); ?>
                    </div>
                <?php endif; ?>
                <?php if ( $show_footer_2 ) : ?>
                    <div class="col-lg-<?php echo esc_attr( piroll_get_theme_mod( 'footer_widget_2_size' ) ); ?>">
                        <?php dynamic_sidebar( 'footer-2' ); ?>
                    </div>
                <?php endif; ?>
                <?php if ( $show_footer_3 ) : ?>
                    <div class="col-lg-<?php echo esc_attr( piroll_get_theme_mod( 'footer_widget_3_size' ) ); ?>">
                        <?php dynamic_sidebar( 'footer-3' ); ?>
                    </div>
                <?php endif; ?>
                <?php if ( $show_footer_4 ) : ?>
                    <div class="col-lg-<?php echo esc_attr( piroll_get_theme_mod( 'footer_widget_4_size' ) ); ?>">
                        <?php dynamic_sidebar( 'footer-4' ); ?>
                    </div>
                <?php endif; ?>
            </div>
    </div>

    </footer>
    <!-- END: Footer -->

<?php endif; ?>

</div>



<?php wp_footer(); ?>
</body>
</html>
