<?php
/**
 * Piroll functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package piroll
 */

if ( ! function_exists( 'piroll_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function piroll_setup() {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on piroll, use a find and replace
         * to change 'piroll' to the name of your theme in all the template files.
         */
        load_theme_textdomain( 'piroll', get_template_directory() . '/languages' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        // Add editor styles.
        add_editor_style();

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support( 'post-thumbnails' );

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(
            array(
                'primary' => esc_html__( 'Primary Menu', 'piroll' ),
            )
        );

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support(
            'html5', array(
                'search-form',
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
            )
        );

        // Set up the WordPress core custom background feature.
        add_theme_support(
            'custom-background', apply_filters(
                'piroll_custom_background_args', array(
                    'default-color' => 'ffffff',
                    'default-image' => '',
                )
            )
        );

        // Add default image sizes
        add_theme_support( 'post-thumbnails' );
        add_image_size( 'piroll_800x600_crop', 800, 600, true );
        add_image_size( 'piroll_800x600', 800 );
        add_image_size( 'piroll_1280x720_crop', 1280, 720, true );
        add_image_size( 'piroll_1280x720', 1280 );
        add_image_size( 'piroll_1920x1080_crop', 1920, 1080, true );
        add_image_size( 'piroll_1920x1080', 1920 );

        // Register the three useful image sizes for use in Add Media modal
        add_filter( 'image_size_names_choose', 'piroll_custom_sizes' );
        if ( ! function_exists( 'piroll_custom_sizes' ) ) :
            function piroll_custom_sizes( $sizes ) {
                return array_merge(
                    $sizes, array(
                        'piroll_800x600_crop' => '800x600 crop',
                        'piroll_800x600' => '800x600',
                        'piroll_1280x720_crop' => '1280x720 crop',
                        'piroll_1280x720' => '1280x720',
                        'piroll_1920x1080_crop' => '1920x1080 crop',
                        'piroll_1920x1080' => '1920x1080',
                    )
                );
            }
        endif;
    }
endif;
add_action( 'after_setup_theme', 'piroll_setup' );
if ( ! isset( $content_width ) ) {
    $content_width = 1140;
}
/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
if ( ! function_exists( 'piroll_widgets_init' ) ) :
    function piroll_widgets_init() {
        register_sidebar(
            array(
                'name' => esc_html__( 'Footer 1 Sidebar', 'piroll' ),
                'id' => 'footer-1',
                'description' => esc_html__( 'First column in widgetized footer', 'piroll' ),
                'before_widget' => '<div id="%1$s" class="nk-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h4 class="nk-widget-title">',
                'after_title' => '</h4>',
            )
        );
        register_sidebar(
            array(
                'name' => esc_html__( 'Footer 2 Sidebar', 'piroll' ),
                'id' => 'footer-2',
                'description' => esc_html__( 'Second column in widgetized footer', 'piroll' ),
                'before_widget' => '<div id="%1$s" class="nk-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h4 class="nk-widget-title">',
                'after_title' => '</h4>',
            )
        );
        register_sidebar(
            array(
                'name' => esc_html__( 'Footer 3 Sidebar', 'piroll' ),
                'id' => 'footer-3',
                'description' => esc_html__( 'Third column in widgetized footer', 'piroll' ),
                'before_widget' => '<div id="%1$s" class="nk-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h4 class="nk-widget-title">',
                'after_title' => '</h4>',
            )
        );
        register_sidebar(
            array(
                'name' => esc_html__( 'Footer 4 Sidebar', 'piroll' ),
                'id' => 'footer-4',
                'description' => esc_html__( 'Fourth column in widgetized footer', 'piroll' ),
                'before_widget' => '<div id="%1$s" class="nk-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h4 class="nk-widget-title">',
                'after_title' => '</h4>',
            )
        );
    }
endif;
add_action( 'widgets_init', 'piroll_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
if ( ! function_exists( 'piroll_scripts' ) ) :
    function piroll_scripts() {
        // Styles
        wp_enqueue_style( 'piroll-style', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/vendor/bootstrap/dist/css/bootstrap.min.css' );
        wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/vendor/fontawesome/css/font-awesome.min.css' );
        wp_enqueue_style( '7-stroke', get_template_directory_uri() . '/assets/vendor/pixeden-stroke-7-icon/pe-icon-7-stroke/dist/pe-icon-7-stroke.min.css' );
        wp_enqueue_style( 'flickity', get_template_directory_uri() . '/assets/vendor/flickity/dist/flickity.min.css' );
        wp_enqueue_style( 'photoswipe', get_template_directory_uri() . '/assets/vendor/photoswipe/dist/photoswipe.css' );
        wp_enqueue_style( 'photoswipedefault-skin', get_template_directory_uri() . '/assets/vendor/photoswipe/dist/default-skin/default-skin.css' );

        $piroll_url = get_template_directory_uri() . '/assets/scss/piroll.min.css';
        $piroll_version = '1.1.3';
        if ( piroll_get_theme_mod( 'style_custom' ) && function_exists( 'nk_theme' ) && nk_theme()->get_compiled_css_url( 'piroll-custom.min.css' ) ) {
            $piroll_url = nk_theme()->get_compiled_css_url( 'piroll-custom.min.css' );
            $piroll_version = nk_theme()->get_compiled_css_version( 'piroll-custom.min.css' );
        }
        wp_enqueue_style( 'piroll', $piroll_url, '', $piroll_version );

        wp_enqueue_script( 'piroll-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );

        wp_enqueue_script( 'piroll-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

        // GSAP
        wp_enqueue_script( 'tween-max', get_template_directory_uri() . '/assets/vendor/gsap/src/minified/TweenMax.min.js', array( 'jquery' ), '', true );
        wp_enqueue_script( 'gsap-scroll-to-plugin', get_template_directory_uri() . '/assets/vendor/gsap/src/minified/plugins/ScrollToPlugin.min.js', array( 'jquery' ), '', true );

        // Bootstrap
        wp_enqueue_script( 'tether', get_template_directory_uri() . '/assets/vendor/tether/dist/js/tether.min.js', array( 'jquery' ), '', true );
        wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/vendor/bootstrap/dist/js/bootstrap.min.js', array( 'jquery' ), '', true );

        // Sticky Kit
        wp_enqueue_script( 'sticky-kit', get_template_directory_uri() . '/assets/vendor/sticky-kit/dist/sticky-kit.min.js', array( 'jquery' ), '', true );

        // Jarallax
        wp_enqueue_script( 'jarallax', get_template_directory_uri() . '/assets/vendor/jarallax/dist/jarallax.min.js', array( 'jquery' ), '', true );
        wp_enqueue_script( 'jarallax-video', get_template_directory_uri() . '/assets/vendor/jarallax/dist/jarallax-video.min.js', array( 'jquery' ), '', true );

        // Flickity
        wp_enqueue_script( 'flickity', get_template_directory_uri() . '/assets/vendor/flickity/dist/flickity.pkgd.min.js', array( 'jquery' ), '', true );

        // Isotope
        wp_enqueue_script( 'isotope', get_template_directory_uri() . '/assets/vendor/isotope/dist/isotope.pkgd.min.js', array( 'jquery' ), '', true );

        // Photoswipe
        wp_enqueue_script( 'photoswipe', get_template_directory_uri() . '/assets/vendor/photoswipe/dist/photoswipe.min.js', array( 'jquery' ), '', true );
        wp_enqueue_script( 'photoswipe-ui-default', get_template_directory_uri() . '/assets/vendor/photoswipe/dist/photoswipe-ui-default.min.js', array( 'jquery' ), '', true );

        // Jquery Validation
        wp_enqueue_script( 'jquery-validate', get_template_directory_uri() . '/assets/vendor/jquery-validation/dist/jquery.validate.min.js', array( 'jquery' ), '', true );

        // Hammer.js
        wp_enqueue_script( 'hammer', get_template_directory_uri() . '/assets/vendor/hammer.js/hammer.min.js', array( 'jquery' ), '', true );

        // nK Share
        wp_enqueue_script( 'nk-share', get_template_directory_uri() . '/assets/plugins/nk-share/nk-share.js', array( 'jquery' ), '', true );

        // NanoSroller
        wp_enqueue_script( 'nanoscroller', get_template_directory_uri() . '/assets/vendor/nanoscroller/bin/javascripts/jquery.nanoscroller.min.js', array( 'jquery' ), '', true );

        // Keymaster
        wp_enqueue_script( 'keymaster', get_template_directory_uri() . '/assets/vendor/keymaster/keymaster.js', array( 'jquery' ), '', true );

        // Piroll
        wp_enqueue_script( 'piroll', get_template_directory_uri() . '/assets/js/piroll.min.js', array( 'tween-max', 'gsap-scroll-to-plugin', 'tether', 'bootstrap', 'sticky-kit', 'jarallax', 'jarallax-video', 'flickity', 'isotope', 'photoswipe', 'photoswipe-ui-default', 'jquery-validate', 'hammer', 'nk-share', 'nanoscroller', 'keymaster' ), '1.1.3', true );
        wp_enqueue_script( 'piroll-init', get_template_directory_uri() . '/assets/js/piroll-init.js', array( 'piroll' ), '1.1.3', true );

        // Piroll WP
        wp_enqueue_script( 'piroll-wp', get_template_directory_uri() . '/assets/js/piroll-wp.js', array( 'jquery' ), '1.1.3', true );

        $dataInit = array(
            'secondaryNavbarBackItem' => esc_html__( 'Back', 'piroll' ),
        );
        wp_localize_script( 'piroll-init', 'pirollInitOptions', $dataInit );

        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
            wp_enqueue_script( 'comment-reply' );
        }
    }
endif;
add_action( 'wp_enqueue_scripts', 'piroll_scripts' );

// Fixed Select2 conflict with ACF and Kirki.
add_filter(
    'acf/settings/select2_version', function() {
        return 4;
    }
);

// Prevent Kirki to load shitty FontAwesome script, that breaks some theme things.
add_filter( 'kirki_load_fontawesome', '__return_false' );

/**
 * Admin References
 */
require get_template_directory() . '/admin/admin.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Comments walker
 */
require get_template_directory() . '/inc/comments-walker.php';

/**
 * Infinite Scroll for Posts
 */
require get_template_directory() . '/inc/lib/nk-infinite-scroll/nk-infinite-scroll.php';
