<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php
$post_type = get_post_type();
if ( ! $post_type ) {
    $post_type = 'page';
}

$acf_navigation = piroll_get_theme_mod( $post_type . '_navigation_custom', true );
$nav_type = piroll_get_theme_mod( 'navigation_type' );
?>

<header class="nk-header<?php echo piroll_get_theme_mod( 'navigation_opaque', $acf_navigation ) ? ' nk-header-opaque' : ''; ?>">
    <!-- START: Navbar -->
    <?php if ( piroll_get_theme_mod( 'navigation_show', $acf_navigation ) ) : ?>
        <?php

        // additional classes
        $navbarAdditionalClasses = '';
        if ( piroll_get_theme_mod( 'navigation_large', $acf_navigation ) ) {
            $navbarAdditionalClasses .= ' nk-navbar-lg';
        }
        if ( piroll_get_theme_mod( 'navigation_transparent', $acf_navigation ) ) {
            $navbarAdditionalClasses .= ' nk-navbar-transparent';
        }
        if ( piroll_get_theme_mod( 'navigation_transparent_always', $acf_navigation ) ) {
            $navbarAdditionalClasses .= ' nk-navbar-transparent-always';
        }
        if ( piroll_get_theme_mod( 'navigation_sticky', $acf_navigation ) ) {
            $navbarAdditionalClasses .= ' nk-navbar-sticky';
        }
        if ( piroll_get_theme_mod( 'navigation_autohide', $acf_navigation ) ) {
            $navbarAdditionalClasses .= ' nk-navbar-autohide';
        }
        if ( piroll_get_theme_mod( 'navigation_white_top_text', $acf_navigation ) ) {
            $navbarAdditionalClasses .= ' nk-navbar-white-text-on-top';
        }
        if ( piroll_get_theme_mod( 'navigation_dark', $acf_navigation ) ) {
            $navbarAdditionalClasses .= ' nk-navbar-dark';
        }
        ?>

        <nav class="nk-navbar nk-navbar-top<?php echo esc_attr( $navbarAdditionalClasses ); ?>">
            <div class="container<?php echo ( piroll_get_theme_mod( 'navigation_boxed', $acf_navigation ) ? '' : '-fluid' ); ?>">
                <div class="nk-nav-table">
                    <?php
                    $logo_position = $nav_type === 'split' ? piroll_get_theme_mod( 'navigation_split_logo_position' ) : false;
                    if ( $nav_type !== 'split' || ! $logo_position ) {
                        echo piroll_nav_logo();
                    }

                    if ( $nav_type === 'default' || $nav_type === 'split' ) :
                        $main_nav_align = piroll_get_theme_mod( 'navigation_default_align' ) ? ' nk-nav-' . piroll_get_theme_mod( 'navigation_default_align' ) : '';
                        wp_nav_menu(
                            array(
                                'theme_location' => 'primary',
                                'container' => '',
                                'menu_class' => esc_attr( 'nk-nav hidden-md-down' . $main_nav_align ),
                                'walker' => new piroll_nav_walker( $logo_position ),
                                'items_wrap' => '<ul id="%1$s" class="%2$s" data-nav-mobile="#nk-full">%3$s</ul>',
                            )
                        );
                    endif;
                    ?>

                    <ul class="nk-nav nk-nav-right nk-nav-icons">
                        <li class="single-icon<?php echo ( $nav_type !== 'fullscreen' ? ' hidden-lg-up' : '' ); ?>">
                            <a href="#" class="nk-navbar-full-toggle no-link-effect">
                                <span class="nk-icon-burger"> <span class="nk-t-1"></span> <span class="nk-t-2"></span> <span class="nk-t-3"></span> </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
    <?php endif; ?>
    <!-- END: Navbar -->

</header>


<!-- START: Fullscreen Navbar -->
<?php
// additional classes
$navbarAdditionalClasses = '';
if ( piroll_get_theme_mod( 'navigation_fullscreen_align' ) ) {
    $navbarAdditionalClasses .= ' nk-navbar-align-' . piroll_get_theme_mod( 'navigation_fullscreen_align' );
}
?>
<nav class="nk-navbar nk-navbar-full<?php echo esc_attr( $navbarAdditionalClasses ); ?>" id="nk-full">
    <?php if ( piroll_get_theme_mod( 'navigation_fullscreen_background_image' ) ) : ?>
        <div class="nk-navbar-bg">
            <div class="bg-image" style="background-image: url('<?php echo piroll_get_theme_mod( 'navigation_fullscreen_background_image' ); ?>')"></div>
        </div>
    <?php endif; ?>

    <div class="nk-nav-table">
        <div class="nk-nav-row">
            <div class="container<?php echo ( piroll_get_theme_mod( 'navigation_boxed' ) ? '' : '-fluid' ); ?>">
                <div class="nk-nav-header">
                    <?php $logo_light = piroll_get_attachment( piroll_get_theme_mod( 'navigation_logo_light' ) ); ?>

                    <?php if ( $logo_light ) : ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="nk-nav-logo">
                            <img src="<?php echo esc_url( $logo_light['src'] ); ?>" alt="
                                                    <?php
                                                    if ( $logo_light['alt'] ) {
                                                        echo esc_attr( $logo_light['alt'] );
                                                    } else {
                                                        get_bloginfo( 'name' );
                                                    }
                                                    ?>
" width="<?php echo esc_attr( piroll_get_theme_mod( 'navigation_logo_width' ) ); ?>">
                        </a>
                    <?php endif; ?>
                    <div class="nk-nav-close nk-navbar-full-toggle">
                        <span class="nk-icon-close"></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="nk-nav-row-full nk-nav-row">
            <div class="nano">
                <div class="nano-content">
                    <div class="nk-nav-table">
                        <div class="nk-nav-row nk-nav-row-full nk-nav-row-center<?php echo ( $nav_type !== 'fullscreen' ? ' nk-navbar-mobile-content' : '' ); ?>">
                            <?php if ( $nav_type !== 'fullscreen' ) : ?>
                                <ul class="nk-nav"></ul>
                            <?php else : ?>
                                <?php
                                wp_nav_menu(
                                    array(
                                        'theme_location' => 'primary',
                                        'container' => '',
                                        'menu_class' => 'nk-nav',
                                        'walker' => new piroll_nav_walker(),
                                    )
                                );
                                ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if ( count( piroll_get_theme_mod( 'navigation_fullscreen_social' ) ) > 0 ) : ?>
            <div class="nk-nav-row">
                <div class="container">
                    <div class="nk-nav-social">
                        <ul>
                            <?php foreach ( piroll_get_theme_mod( 'navigation_fullscreen_social' ) as $socialItem ) : ?>
                                <li><a href="<?php echo esc_url( $socialItem['link_url'] ); ?>" target="_blank"><span class="<?php echo esc_attr( $socialItem['soc_class'] ); ?>"></span></a></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</nav>

<!-- END: Fullscreen Navbar -->


<div class="nk-main">
