<?php

if ( ! function_exists( 'piroll_move_comment_field_to_bottom' ) ) :
    function piroll_move_comment_field_to_bottom( $fields ) {
        $comment_field = $fields['comment'];
        unset( $fields['comment'] );
        $fields['comment'] = $comment_field;
        return $fields;
    }
endif;
add_filter( 'comment_form_fields', 'piroll_move_comment_field_to_bottom' );

/** COMMENTS WALKER */
class piroll_walker_comment extends Walker_Comment {


    // init classwide variables
    var $tree_type = 'comment';
    var $db_fields = array(
        'parent' => 'comment_parent',
        'id' => 'comment_ID',
    );

    /** CONSTRUCTOR
     * You'll have to use this if you plan to get to the top of the comments list, as
     * start_lvl() only goes as high as 1 deep nested comments */
    function __construct() {
        ?>

        <!--<ul class="comments-list">-->

        <?php
    }

    /** START_LVL
     * Starts the list before the CHILD elements are added. */
    function start_lvl( &$output, $depth = 0, $args = array() ) {
        $GLOBALS['comment_depth'] = $depth + 1;
        $output .= '<!--<ul class="child-comment">-->';
    }

    /** END_LVL
     * Ends the children list of after the elements are added. */
    function end_lvl( &$output, $depth = 0, $args = array() ) {
        $GLOBALS['comment_depth'] = $depth + 1;
        $output .= '<!-- /.children -->';
    }

    /** START_EL */
    function start_el( &$output, $comment, $depth = 0, $args = array(), $id = 0 ) {
        $depth++;
        $GLOBALS['comment_depth'] = $depth;
        $GLOBALS['comment'] = $comment;

        if ( ! empty( $args['callback'] ) ) {
            ob_start();
            call_user_func( $args['callback'], $comment, $args, $depth );
            $output .= ob_get_clean();
            return;
        }

        if ( ( 'pingback' == $comment->comment_type || 'trackback' == $comment->comment_type ) && $args['short_ping'] ) {
            ob_start();
            $this->ping( $comment, $depth, $args );
            $output .= ob_get_clean();
        } else {
            ob_start();
            $this->comment( $comment, $depth, $args );
            $output .= ob_get_clean();
        }
        ?>
        <?php
    }

    function end_el( &$output, $comment, $depth = 0, $args = array() ) {
        $output .= "</div><!-- #comment-## -->\n";
    }

    protected function ping( $comment, $depth, $args ) {
        $parent_class = ( empty( $args['has_children'] ) ? '' : 'parent' );
        ?>
        <div class="nk-comment nk-comment-ping" <?php comment_class( $parent_class ); ?> id="comment-<?php comment_ID(); ?>">
        <div class="comment-body">
            <?php esc_html_e( 'Pingback:', 'piroll' ); ?> <?php comment_author_link( $comment ); ?> <?php edit_comment_link( esc_html__( 'Edit', 'piroll' ), '<span class="edit-link">', '</span>' ); ?>
        </div>
        <?php
    }

    protected function comment( $comment, $depth, $args ) {
        $parent_class = ( empty( $args['has_children'] ) ? '' : 'parent' );
        ?>
        <div class="nk-comment" <?php comment_class( $parent_class ); ?> id="comment-<?php comment_ID(); ?>">

            <div class="nk-comment-avatar">
                <?php echo( $args['avatar_size'] != 0 ? get_avatar( $comment, $args['avatar_size'] ) : '' ); ?>
            </div>
            <div class="nk-comment-meta">
                <div class="nk-comment-name">
                    <?php echo get_comment_author_link(); ?>
                    <sup class="hidden-sm-down"><?php edit_comment_link( '(Edit)' ); ?></sup>
                </div>
                <div class="nk-comment-reply">
                    <?php
                    comment_reply_link(
                        array_merge(
                            $args, array(
                                'add_below' => isset( $args['add_below'] ) ? $args['add_below'] : 'comment',
                                'depth' => $depth,
                                'max_depth' => $args['max_depth'],
                                'reply_text' => sprintf( esc_html__( '%s Reply', 'piroll' ), '<i class="ion-reply"></i>' ),
                            )
                        ), $comment->comment_ID
                    );
                    ?>
                </div>
                <div class="nk-comment-date"><?php comment_date(); ?></div>
            </div>
            <div class="nk-comment-text">
                <p>
                    <?php if ( ! $comment->comment_approved ) : ?>
                        <em class="comment-awaiting-moderation"><?php esc_html__( 'Your comment is awaiting moderation.', 'piroll' ); ?></em>
                        <?php
                    else :
                        echo wp_kses_post( get_comment_text() );
                        ?>
                    <?php endif; ?>
                </p>
            </div>
            <div class="clearfix"></div>
            <?php
    }

    /** DESTRUCTOR
     * I'm just using this since we needed to use the constructor to reach the top
     * of the comments list, just seems to balance out nicely:) */
    function __destruct() {

        ?>

        <!-- /#comment-list -->

        <?php
    }
}
