'use strict';

/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 24);
/******/ })
/************************************************************************/
/******/ ({

/***/ 24:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(25);


/***/ }),

/***/ 25:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*
 * Inifinite Scroll
 *
 * Don't touch the main plugin code! Scroll down and look at initialization.
 */
(function ($) {
    var infiniteScrollObjects = [];

    /* Instance */
    function InfiniteScroll($infiniteBlock, userOptions) {
        var self = this;

        self.$block = $infiniteBlock;

        // default options and callback functions
        self.options = $.extend({
            id: $infiniteBlock.attr('data-id'),
            nextPageUrl: $infiniteBlock.attr('data-next-page-url'),

            // set true if you want to load fetch new items on scrolling page
            infinite: false,

            init: function init() {},
            createLoadMoreButton: function createLoadMoreButton() {
                if (!this.loadMoreButton) {
                    this.loadMoreButton = $('<div>').insertBefore(this.$block);
                }
                return this.loadMoreButton.html('Load More');
            },
            createNoMoreButton: function createNoMoreButton() {
                return this.loadMoreButton.html('No More');
            },
            startLoading: function startLoading() {
                // console.log('start loading');
            },
            endLoading: function endLoading() {
                // console.log('end loading');

                // Update load more button
                if (this.options.nextPageUrl) {
                    this.options.createLoadMoreButton.apply(this);
                } else {
                    this.options.createNoMoreButton.apply(this);
                }
            },

            // eslint-disable-next-line
            onLoad: function onLoad($newBlock, data) {
                // console.log('on load', $newBlock, data);
            },

            // eslint-disable-next-line
            onLoaded: function onLoaded($newBlock, data) {
                // console.log('on loaded', $newBlock, data);
            }
        }, userOptions || {});

        infiniteScrollObjects.push(self);

        self.init();
    }

    InfiniteScroll.prototype = $.extend({

        // init
        init: function init() {
            var self = this;

            self.options.init.apply(self);

            // on click load more
            self.options.createLoadMoreButton.apply(self).on('click', function () {
                self.loadMore();
            });
        },


        // load more action
        loadMore: function loadMore() {
            var self = this;

            if (self.busy || !self.options.nextPageUrl) {
                return;
            }
            self.busy = true;

            // loading event
            self.options.startLoading.apply(self);

            // load to invisible container, then append to posts container
            $.get(self.options.nextPageUrl, {}, function (data) {
                data = data.replace('<body', '<body><div id="nk-infinite-load-body"').replace('</body>', '</div></body>');
                var $body = $(data).filter('#nk-infinite-load-body');

                // find current block on new page
                var $newBlock = $body.find('[data-nk-infinite-scroll="true"][data-id="' + self.options.id + '"]');

                if ($newBlock.length) {
                    // on load event
                    self.options.onLoad.apply(self, [$newBlock, data]);
                }

                // update next page data
                self.options.nextPageUrl = $newBlock.attr('data-next-page-url');

                self.busy = false;

                // loading event
                self.options.endLoading.apply(self);

                // on loaded event
                self.options.onLoaded.apply(self, [$newBlock, data]);
            });
        }
    }, InfiniteScroll.prototype);

    /**
     * Get window size
     */
    var $wnd = $(window);
    var wndW = 0;
    var wndH = 0;
    function getWndSize() {
        wndW = $wnd.width();
        wndH = $wnd.height();
    }
    getWndSize();
    $wnd.on('resize load orientationchange', getWndSize);

    /**
     * In Viewport checker
     * return visible percent from 0 to 1
     */
    function isInViewport($item) {
        var rect = $item[0].getBoundingClientRect();
        return rect.bottom >= 0 && rect.right >= 0 && rect.top <= wndH && rect.left <= wndW;
    }

    /* Load new posts when scrolled page */
    var scrollTimeout = void 0;
    $(window).on('scroll resize load', function () {
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(function () {
            for (var k = 0; k < infiniteScrollObjects.length; k++) {
                var item = infiniteScrollObjects[k];
                if (item.options.infinite && isInViewport(item.$block)) {
                    item.loadMore();
                }
            }
        }, 20);
    });

    // Global init function
    window.nkInfiniteScroll = function ($block, options) {
        $block.each(function () {
            return new InfiniteScroll($(this), options);
        });
    };
})(jQuery);

/**
 * INIT CODE
 */
(function ($) {
    var loadMorePosts = window.nk_infinite_scroll.load_more_posts;
    var noMorePosts = window.nk_infinite_scroll.no_more_posts;

    // init all infinite blocks
    window.nkInfiniteScroll($('[data-nk-infinite-scroll="true"]'), {
        init: function init() {
            this.$pagination = this.$block.prev('.nk-pagination');
            this.$container = this.$pagination.prev().find('.nk-load-more-container, .nk-infinite-scroll-container');
            this.options.infinite = this.$container.hasClass('nk-infinite-scroll-container');
        },
        createLoadMoreButton: function createLoadMoreButton() {
            if (!this.loadMoreButton) {
                this.loadMoreButton = this.$pagination.html('<a href="javascript:void(0)">').children('a');
            }
            return this.loadMoreButton.html(loadMorePosts);
        },
        createNoMoreButton: function createNoMoreButton() {
            this.loadMoreButton = this.$pagination.html('<span>').children('span');
            return this.loadMoreButton.html(noMorePosts);
        },


        // Show preloader
        startLoading: function startLoading() {
            this.loadMoreButton.html('<i class="fa fa-cog fa-spin fa-fw"></i>');
        },


        // Insert new loaded items
        // eslint-disable-next-line
        onLoad: function onLoad($newBlock, data) {
            var self = this;
            var $newCont = $newBlock.prev('.nk-pagination').prev().find('.nk-load-more-container, .nk-infinite-scroll-container');

            // update filter
            var $newFilter = $newCont.prev('.nk-isotope-filter');
            var $curFilter = self.$container.prev('.nk-isotope-filter');
            if ($newFilter.length && $curFilter.length) {
                $newFilter.find('[data-term-id]').each(function () {
                    var $filterItem = $(this);
                    if (!$curFilter.find('[data-term-id="' + $filterItem.attr('data-term-id') + '"]').length) {
                        $curFilter.append($filterItem);
                    }
                });
            }

            // update items
            var $items = $newCont.children();
            self.$container.append($items);

            if (self.$container.hasClass('nk-isotope')) {
                self.$container.isotope('appended', $items);

                self.$container.imagesLoaded().progress(function () {
                    self.$container.isotope('layout');
                });

                // fix isotope layout after appended item
                setTimeout(function () {
                    self.$container.isotope('layout');
                }, 100);
            }
        }
    });
})(jQuery);

/***/ })

/******/ });