<?php
/**
 * Infinite scroll for nK themes
 */
if ( ! function_exists( 'piroll_infinite_scroll_init' ) ) :
    function piroll_infinite_scroll_init( $nk_query = null ) {
        if ( $nk_query == null ) {
            global $wp_query;
        } else {
            $wp_query = $nk_query;
        }

        wp_enqueue_script( 'nk-infinite-scroll', get_template_directory_uri() . '/inc/lib/nk-infinite-scroll/js/load-posts.js', array( 'jquery' ), '', true );

        // Add some translated strings for the JS
        wp_localize_script(
            'nk-infinite-scroll',
            'nk_infinite_scroll',
            array(
                'load_more_posts' => esc_html__( 'Load More Posts', 'piroll' ),
                'load_more_works' => esc_html__( 'Load More Works', 'piroll' ),
                'no_more_posts' => esc_html__( 'No More Posts', 'piroll' ),
                'no_more_works' => esc_html__( 'No More Works', 'piroll' ),
            )
        );

        // What page are we on? And what is the pages limit?
        $startPage = intval( max( 1, get_query_var( 'page' ), get_query_var( 'paged' ) ) );
        $maxPages = $wp_query->max_num_pages < $startPage ? $startPage : $wp_query->max_num_pages;
        $nextPageURL = ( ! $maxPages || $maxPages >= $startPage + 1 ) ? get_pagenum_link( $startPage + 1 ) : false;

        // id
        static $nk_infinite_scroll_id = 0;
        $nk_infinite_scroll_id++;

        ?>
            <div data-nk-infinite-scroll="true"
                data-id="<?php echo esc_attr( $nk_infinite_scroll_id ); ?>"
                data-next-page-url="<?php echo esc_url( $nextPageURL ); ?>">
            </div>
        <?php
    }
endif;
