<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Piroll
 */

if ( ! function_exists( 'piroll_posts_navigation' ) ) :
    /**
     * Display navigation to next/previous set of posts when applicable.
     */
    function piroll_posts_navigation( $query = null ) {
        if ( $query == null ) {
            $queryName = isset( $GLOBALS['nk_query'] ) ? 'nk_query' : 'wp_query';

            // Don't print empty markup if there's only one page.
            if ( $GLOBALS[ $queryName ]->max_num_pages < 1 ) {
                return;
            }

            $query = $GLOBALS[ $queryName ];
        }
        $page_links = paginate_links(
            apply_filters(
                'nk_pagination_args', array(
                    'base' => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
                    'format' => '',
                    'add_args' => '',
                    'current' => max( 1, get_query_var( 'page' ), get_query_var( 'paged' ) ),
                    'total' => $query->max_num_pages,
                    'prev_text' => '<span class="nk-icon-arrow-left"></span>',
                    'next_text' => '<span class="nk-icon-arrow-right"></span>',
                    'type' => 'array',
                    'end_size' => 3,
                    'mid_size' => 3,
                )
            )
        );
        if ( ! is_array( $page_links ) ) {
            return;
        } else {
            $page_prev_or_next_links = $page_links;
            $prev_link = array_shift( $page_prev_or_next_links );
            $next_link = array_pop( $page_prev_or_next_links );
        }

        ?>
        <div class="nk-pagination nk-pagination-center">
            <div class="container">
                <?php
                if ( isset( $next_link ) && $next_link ) {
                    preg_match_all( '/<a[^>]+href=([\'"])(.+?)\1[^>]*>/i', $next_link, $result );

                    if ( isset( $result[2][0] ) ) {
                        ?>
                        <a href="<?php echo esc_url( $result[2][0] ); ?>" class="nk-pagination-prev"><span class="pe-7s-angle-left"></span> <?php echo esc_html__( 'Older', 'piroll' ); ?></a>
                        <?php
                    }
                }
                if ( isset( $prev_link ) && $prev_link ) {
                    preg_match_all( '/<a[^>]+href=([\'"])(.+?)\1[^>]*>/i', $prev_link, $result );

                    if ( isset( $result[2][0] ) ) {
                        ?>
                        <a href="<?php echo esc_url( $result[2][0] ); ?>" class="nk-pagination-next"><?php echo esc_html__( 'Newer', 'piroll' ); ?> <span class="pe-7s-angle-right"></span></a>
                        <?php
                    }
                }
                ?>
            </div>
        </div>
        <?php
    }
endif;

if ( ! function_exists( 'piroll_show_media_extra_attachment_fields' ) ) :
    function piroll_show_media_extra_attachment_fields( $form_fields, $post ) {
        $form_fields['link'] = array(
            'label' => 'Link',
            'input' => 'text',
            'value' => get_post_meta( $post->ID, 'link', true ),
            'helps' => esc_html__( 'This property is used only in the posts, portfolio galleries or in nk_images_carousel shortcode', 'piroll' ),
        );
        return $form_fields;
    }
endif;

if ( ! function_exists( 'piroll_save_media_extra_attachment_fields' ) ) :
    function piroll_save_media_extra_attachment_fields( $post, $attachment ) {
        if ( isset( $attachment['link'] ) ) {
            update_post_meta( $post['ID'], 'link', $attachment['link'] );
        }
        return $post;
    }
endif;
add_filter( 'attachment_fields_to_edit', 'piroll_show_media_extra_attachment_fields', 10, 2 );
add_filter( 'attachment_fields_to_save', 'piroll_save_media_extra_attachment_fields', 10, 2 );



if ( ! function_exists( 'piroll_sharing_links' ) ) :
    /**
     * Prints HTML with sharing links
     */
    function piroll_sharing_links( $social_links ) {
        $arSocial = piroll_get_social_list( 'small' );

        $title = get_the_title();
        $link = get_the_permalink();
        $media = get_the_post_thumbnail_url( null, 'full' );

        foreach ( $social_links as $key => $socialItem ) {
            $soc_title = sprintf( esc_html__( 'Share page on %s', 'piroll' ), $arSocial[ $socialItem['soc_class'] ] );
            $soc_type = str_replace( ' ', '-', mb_strtolower( $arSocial[ $socialItem['soc_class'] ] ) );
            $soc_text = $arSocial[ $socialItem['soc_class'] ];
            ?>
            <a href="#"
               title="<?php echo esc_attr( $soc_title ); ?>"
               data-share="<?php echo esc_attr( $soc_type ); ?>"
               data-share-text="<?php echo esc_attr( $title ); ?>"
               data-share-link="<?php echo esc_attr( $link ); ?>"
               data-share-media="<?php echo esc_attr( $media ); ?>"
            ><?php echo esc_html( $soc_text ); ?></a><?php
                echo ( $key < count( $social_links ) - 1 ? ', ' : '' );
        }
    }
endif;
