<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Piroll
 */

get_header();
get_template_part( '/template-parts/header/archive' );

    get_template_part( '/template-parts/content-wrap-start' );
?>
        <?php if ( piroll_get_theme_mod( 'archive_show_title', true ) && ! piroll_get_theme_mod( 'archive_header_show', true ) ) : ?>
            <div class="nk-gap-4"></div>
            <?php
            if ( is_front_page() ) {
                echo '<h1 class="nk-title">';
                echo wp_get_document_title();
                echo '</h1>';
            } else {
                the_archive_title( '<h1 class="nk-title">', '</h1>' );
            }
            ?>
            <?php
        endif;

        get_template_part( '/template-parts/content-archive-list' );

        get_template_part( '/template-parts/content-wrap-end' );

        $pagination = piroll_get_theme_mod( 'archive_pagination', true );
        if ( $pagination ) {
            piroll_posts_navigation();

            if ( $pagination == 'infinite' || $pagination == 'load_more' ) {
                piroll_infinite_scroll_init();
            }
        }
        ?>
<?php
get_footer();
