<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Piroll
 */

get_header();
get_template_part( '/template-parts/header/single' );
$post_type = get_post_type();
if ( ! $post_type ) {
    $post_type = 'page';
}
// use acf settings (return true or null)
$acf_meta = piroll_get_theme_mod( 'page_meta_custom', true );
$acf_content = piroll_get_theme_mod( 'content_page_custom', true );

$col_class = 'col-12';
?>
    <div class="<?php echo ( piroll_get_theme_mod( 'single_page_boxed', $acf_content ) ? 'container' : 'container-fluid' ); ?>">
        <div class="row">
            <div class="<?php echo esc_attr( $col_class ); ?>">
                    <?php if ( piroll_get_theme_mod( 'single_page_paddings', $acf_content ) ) : ?>
                        <div class="nk-gap-4"></div>
                    <?php endif; ?>
                <?php
                while ( have_posts() ) :
                    the_post();

                    get_template_part( 'template-parts/content', 'page' );

                    // If comments are open or we have at least one comment, load up the comment template.
                    if ( comments_open() || get_comments_number() ) :
                        comments_template();
                    endif;

                endwhile; // End of the loop.
                ?>
                <?php if ( piroll_get_theme_mod( 'single_page_paddings', $acf_content ) ) : ?>
                    <div class="nk-gap-4"></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php
get_footer();
