<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Piroll
 */
get_header();
get_template_part( '/template-parts/header/search' );

    get_template_part( '/template-parts/content-wrap-start' );

if ( piroll_get_theme_mod( 'search_show_title', true ) && ! piroll_get_theme_mod( 'search_header_show', true ) ) : ?>
            <div class="nk-gap-4"></div>
            <h1 class="nk-title"><?php sprintf( esc_html__( 'Search Results for "%s" Query', 'piroll' ), get_search_query() ); ?></h1>
        <?php
        endif;

        get_template_part( '/template-parts/content-archive-list' );

    get_template_part( '/template-parts/content-wrap-end' );

if ( have_posts() ) {
    $pagination = piroll_get_theme_mod( 'search_pagination', true );
    if ( $pagination ) {
        piroll_posts_navigation();

        if ( $pagination == 'infinite' || $pagination == 'load_more' ) {
            piroll_infinite_scroll_init();
        }
    }
}

get_footer();
