<?php
/**
 * @package Piroll
 */
$type = piroll_post_type_is();
$attachment = piroll_get_attachment( get_post_thumbnail_id( get_the_ID() ), 'piroll_800x600' );
$category = get_the_category();
$categories_string = '';
if ( $category ) {
    foreach ( $category as $cat ) {
        if ( $categories_string ) {
            $categories_string .= ',';
        }
        $categories_string .= $cat->slug;
    }
}
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'nk-isotope-item' ); ?> data-filter="<?php echo esc_attr( $categories_string ); ?>">
    <div class="nk-blog-post">
        <?php if ( isset( $attachment['src'] ) && ! empty( $attachment['src'] ) ) : ?>
            <div class="nk-post-thumb">
                <a href="<?php echo esc_url( get_permalink() ); ?>">
                    <img src="<?php echo esc_url( $attachment['src'] ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>" class="nk-img-stretch">
                </a>
            </div>
        <?php endif; ?>

        <?php if ( get_the_title() ) : ?>
            <?php the_title( sprintf( '<h2 class="nk-post-title h5"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
        <?php else : ?>
            <h2 class="nk-post-title h5"><a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark"><?php echo esc_html__( '(no title)', 'piroll' ); ?></a></h2>
        <?php endif; ?>

        <div class="nk-post-meta">
            <?php echo get_the_time( esc_html__( 'F j, Y ', 'piroll' ) ); ?>
            <?php if ( isset( $category[0] ) ) : ?>
                / <a href="<?php echo get_category_link( $category[0]->cat_ID ); ?>"><?php echo esc_html( $category[0]->name ); ?></a>
            <?php endif; ?>
        </div>

        <div class="nk-post-text">
            <?php
            $content_type = piroll_get_theme_mod( $type . '_posts_content', true );
            $content_trim_cnt = piroll_get_theme_mod( $type . '_posts_content_excerpt_count', true );

            if ( $content_type == 'excerpt' && $content_trim_cnt > 0 ) {
                echo wp_trim_words( do_shortcode( get_the_content() ), $content_trim_cnt, '...' );
            } elseif ( $content_type == 'more' ) {
                the_content();
            }
            ?>
        </div>
    </div>
</div>
