<?php
/**
 * @package Piroll
 */
$type = piroll_post_type_is();
$attachment = piroll_get_attachment( get_post_thumbnail_id( get_the_ID() ), 'piroll_800x600_crop' );
$category = get_the_category();
$categories_string = '';
foreach ( $category as $cat ) {
    if ( $categories_string ) {
        $categories_string .= ',';
    }
    $categories_string .= $cat->slug;
}
?>

<div id="post-<?php the_ID(); ?>" <?php post_class( 'nk-isotope-item' ); ?> data-filter="<?php echo esc_attr( $categories_string ); ?>">
    <div class="nk-blog-post">
        <?php if ( isset( $attachment['src'] ) && ! empty( $attachment['src'] ) ) : ?>
            <div class="nk-post-thumb" style="background-image: url('<?php echo esc_url( $attachment['src'] ); ?>')"></div>
        <?php endif; ?>
        <div class="nk-post-content">
            <div>
                <div class="nk-post-date">
                    <?php echo get_the_time( esc_html__( 'F j, Y ', 'piroll' ) ); ?>
                </div>
                <?php the_title( sprintf( '<h2 class="nk-post-title h3"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
                <a class="nk-post-more" href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html__( 'Read More', 'piroll' ); ?></a>
            </div>
        </div>
    </div>
</div>
