<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Piroll
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php if ( piroll_get_theme_mod( 'single_page_show_title', true ) ) : ?>
        <?php if ( piroll_get_theme_mod( 'single_page_header_show', piroll_get_theme_mod( 'content_page_custom', true ) ) ) : ?>
        <div class="nk-gap-4"></div>
        <?php endif; ?>
        <?php the_title( '<h1>', '</h1>' ); ?>
        <div class="nk-gap"></div>
    <?php endif; ?>
    <div class="entry-content">
        <?php
        the_content();
        ?>

        <div class="clearfix"></div>

        <?php
        wp_link_pages(
            array(
                'before'           => '<p><strong class="text-dark-1">' . esc_html__( 'Pages:', 'piroll' ) . '</strong>',
                'after'            => '</p>',
                'link_before'      => '',
                'link_after'       => '',
                'next_or_number'   => 'number',
                'separator'        => ' ',
                'nextpagelink'     => esc_html__( 'Next page', 'piroll' ),
                'previouspagelink' => esc_html__( 'Previous page', 'piroll' ),
                'pagelink'         => '%',
                'echo'             => 1,
            )
        );
        ?>
    </div><!-- .entry-content -->
</article><!-- #post-## -->
