<?php
/**
 * @package Piroll
 */

$style = piroll_get_metabox( 'single_portfolio_style' );
$gallery = piroll_get_metabox( 'single_portfolio_gallery' );
$images_size = piroll_get_metabox( 'single_portfolio_gallery_images_size' );
if ( ! $images_size ) {
    $images_size = 'piroll_1280x720';
}
$content_position = piroll_get_metabox( 'single_portfolio_content_position' );


// function to print content of the portfolio
if ( ! function_exists( 'piroll_print_portfolio_content' ) ) :
    function piroll_print_portfolio_content() {
        ?>
        <div class="nk-portfolio-text">
            <?php the_content(); ?>

            <?php
            wp_link_pages(
                array(
                    'before'           => '<p><strong class="text-dark-1">' . esc_html__( 'Pages:', 'piroll' ) . '</strong>',
                    'after'            => '</p>',
                    'link_before'      => '',
                    'link_after'       => '',
                    'next_or_number'   => 'number',
                    'separator'        => ' ',
                    'nextpagelink'     => esc_html__( 'Next page', 'piroll' ),
                    'previouspagelink' => esc_html__( 'Previous page', 'piroll' ),
                    'pagelink'         => '%',
                    'echo'             => 1,
                )
            );
            ?>
        </div>
        <?php
    }
endif;


// function to print details of the portfolio
if ( ! function_exists( 'piroll_print_portfolio_details' ) ) :
    function piroll_print_portfolio_details() {
        $client = piroll_get_metabox( 'single_portfolio_client' );
        $social_links = piroll_get_theme_mod( 'sharing_links' );
        $show_social = piroll_get_theme_mod( 'single_portfolio_show_share' ) && count( $social_links ) > 0;
        $show_date = piroll_get_theme_mod( 'single_portfolio_show_date' );

        if ( ! $client && ! $show_social && ! $show_date ) {
            return;
        }

        ?>
        <table class="nk-portfolio-details">
            <tbody>
            <?php if ( $client ) : ?>
                <tr>
                    <td><strong><?php echo esc_html__( 'Client:', 'piroll' ); ?></strong></td>
                    <td><?php echo esc_html( $client ); ?></td>
                </tr>
            <?php endif; ?>

            <?php if ( $show_date ) : ?>
                <tr>
                    <td><strong><?php echo esc_html__( 'Date:', 'piroll' ); ?></strong></td>
                    <td><?php the_time( esc_html__( 'F j, Y ', 'piroll' ) ); ?></td>
                </tr>
            <?php endif; ?>

            <?php if ( $show_social ) : ?>
                <tr>
                    <td><strong><?php echo esc_html__( 'Share:', 'piroll' ); ?></strong></td>
                    <td>
                        <?php piroll_sharing_links( $social_links ); ?>
                    </td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
        <?php
    }
endif;


// function to print content
if ( ! function_exists( 'piroll_get_portfolio_content' ) ) :
    function piroll_get_portfolio_content( $content_style = false ) {
        if ( $content_style == false ) {
            $content_style = piroll_get_metabox( 'single_portfolio_content_style' );
        }
        $show_title = piroll_get_metabox( 'single_portfolio_content_show_title' );

        // print style
        if ( $content_style == 'columns_1' || $content_style == 'columns_2' ) :
            ?>
            <div class="container">
                <div class="nk-portfolio-single">
                    <div class="nk-gap-4 mb-2"></div>
                    <?php
                    if ( $show_title ) {
                        the_title( '<h1 class="nk-portfolio-title">', '</h1>' );
                    }
                    ?>
                    <div class="row vertical-gap">
                        <div class="col-lg-8 <?php echo ( $content_style == 'columns_2' ? 'push-lg-4' : '' ); ?>">
                            <?php piroll_print_portfolio_content(); ?>
                        </div>
                        <div class="col-lg-4 <?php echo ( $content_style == 'columns_2' ? 'pull-lg-8' : '' ); ?>">
                            <?php piroll_print_portfolio_details(); ?>
                        </div>
                    </div>
                    <div class="nk-gap-4 mnb-10"></div>
                </div>
            </div>
        <?php elseif ( $content_style == 'custom' ) : ?>
            <div class="container">
                <div class="nk-portfolio-single">
                    <div class="nk-gap-4 mb-2"></div>
                    <?php
                    if ( $show_title ) {
                        the_title( '<h1 class="nk-portfolio-title">', '</h1>' );
                    }
                    ?>
                    <?php piroll_print_portfolio_content(); ?>
                    <div class="nk-gap-4 mnb-10"></div>
                </div>
            </div>
        <?php elseif ( $content_style == 'custom_no_gap' ) : ?>
            <div class="container-fluid">
                <div class="nk-portfolio-single">
                    <?php
                    if ( $show_title ) {
                        the_title( '<h1 class="nk-portfolio-title">', '</h1>' );
                    }
                    ?>
                    <?php piroll_print_portfolio_content(); ?>
                </div>
            </div>
        <?php else : ?>
            <div class="nk-portfolio-info">
                <?php
                if ( $show_title ) {
                    the_title( '<h1 class="nk-portfolio-title">', '</h1>' );
                }
                ?>
                <?php piroll_print_portfolio_content(); ?>
                <?php piroll_print_portfolio_details(); ?>
            </div>
            <?php
        endif;
    }
endif;
?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php
    if ( $content_position == 'top' && $style != 'half' && $style != 'half_inverse' ) {
        piroll_get_portfolio_content();
    }
    ?>

    <?php if ( $style == 'slider' ) : ?>
        <?php if ( $gallery && count( $gallery ) > 0 ) { ?>
            <?php
            $slider_autoplay = piroll_get_metabox( 'single_portfolio_slider_autoplay' );
            $slider_arrows = piroll_get_metabox( 'single_portfolio_slider_arrows' );
            ?>
            <div class="nk-carousel-3 nk-carousel-no-margin nk-carousel-all-visible" data-size="1" data-autoplay="<?php echo esc_attr( $slider_autoplay ); ?>" data-arrows="<?php echo ( $slider_arrows ? 'true' : 'false' ); ?>">
                <div class="nk-carousel-inner">
                    <?php
                    foreach ( $gallery as $img ) {
                        $attachment = piroll_get_attachment( $img['ID'], $images_size );
                        $link = get_post_meta( $img['ID'], 'link', true );
                        if ( $attachment ) {
                            echo '<div><div>';
                            if ( $link ) {
                                echo '<a href="' . esc_url( $link ) . '">';
                            }
                            echo '<img src="' . esc_url( $attachment['src'] ) . '" alt="' . ( $attachment['alt'] ? $attachment['alt'] : '' ) . '" class="nk-img-stretch">';
                            if ( $link ) {
                                echo '</a>';
                            }
                            echo '</div></div>';
                        }
                    }
                    ?>
                </div>
            </div>
        <?php } ?>
    <?php elseif ( $style == 'gallery' ) : ?>
        <?php if ( $gallery && count( $gallery ) > 0 ) { ?>
            <?php
            if ( $content_position != 'top' ) {
                ?>
                 <div class="nk-gap-5"></div>
                <?php
            }
            ?>
            <div class="container">
                <div class="nk-isotope nk-isotope-2-cols nk-isotope-gap nk-popup-gallery nk-portfolio-list">
                    <?php
                    foreach ( $gallery as $img ) {
                        $attachment = piroll_get_attachment( $img['ID'], 'piroll_800x600' );
                        $attachment_full = piroll_get_attachment( $img['ID'], 'piroll_1920x1080' );
                        $link = get_post_meta( $img['ID'], 'link', true );
                        if ( $attachment ) {
                            echo '<div class="nk-isotope-item"><div class="nk-portfolio-item"><a href="' . esc_url( $link ? $link : $attachment_full['src'] ) . '" class="' . ( $link ? '' : 'nk-gallery-item' ) . ' nk-portfolio-item-image" data-size="' . esc_attr( $attachment_full['width'] ) . 'x' . esc_attr( $attachment_full['height'] ) . '" style="background-image: url(' . esc_url( $attachment['src'] ) . ')"><img src="' . esc_url( $attachment['src'] ) . '" alt="' . ( $attachment['alt'] ? $attachment['alt'] : '' ) . '"></a></div></div>';
                        }
                    }
                    ?>
                </div>
            </div>
            <?php
            if ( $content_position == 'top' ) {
                ?>
                 <div class="nk-gap-5"></div>
                <?php
            }
            ?>
        <?php } ?>
    <?php elseif ( $style == 'gallery_2' ) : ?>
        <?php if ( $gallery && count( $gallery ) > 0 ) { ?>
            <?php
            if ( $content_position != 'top' ) {
                ?>
                 <div class="nk-gap-5"></div>
                <?php
            }
            ?>
            <div class="nk-portfolio-images mnt-30 mnb-30">
                <?php
                foreach ( $gallery as $img ) {
                    $attachment = piroll_get_attachment( $img['ID'], 'piroll_1920x1080' );
                    $link = get_post_meta( $img['ID'], 'link', true );
                    if ( $attachment ) {
                        echo '<div class="m-30">';
                        if ( $link ) {
                            echo '<a href="' . esc_url( $link ) . '">';
                        }
                        echo '<img src="' . esc_url( $attachment['src'] ) . '" alt="' . esc_attr( $attachment['alt'] ) . '">';
                        if ( $link ) {
                            echo '</a>';
                        }
                        echo '</div>';
                    }
                }
                ?>
            </div>
            <?php
            if ( $content_position == 'top' ) {
                ?>
                 <div class="nk-gap-5"></div>
                <?php
            }
            ?>
        <?php } ?>
    <?php elseif ( $style == 'header' ) : ?>
        <?php
        $header_text = piroll_get_metabox( 'single_portfolio_header_text' );
        $header_image = piroll_get_attachment( piroll_get_metabox( 'single_portfolio_header_image' ), 'piroll_800x600' );
        ?>
        <div class="nk-portfolio-single-header">
            <div>
                <div class="container">
                    <div class="row vertical-gap d-md-flex">
                        <div class="col-md-6">
                            <?php the_title( '<h1 class="nk-portfolio-title">', '</h1>' ); ?>
                            <?php
                            if ( $header_text ) {
                                echo wp_kses_post( $header_text );
                            }
                            ?>
                        </div>
                        <div class="col-md-6">
                            <?php
                            if ( $header_image ) {
                                echo '<div><div><img src="' . esc_url( $header_image['src'] ) . '" alt="' . ( $header_image['alt'] ? $header_image['alt'] : '' ) . '" class="nk-img-fit"></div></div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php elseif ( $style == 'video' ) : ?>
        <?php
        $video_url = piroll_get_metabox( 'single_portfolio_video_url' );
        $video_thumb = piroll_get_attachment( piroll_get_metabox( 'single_portfolio_video_thumbnail' ), 'piroll_1920x1080' );
        ?>

        <?php if ( $video_url ) : ?>
            <div class="nk-plain-video" data-video="<?php echo esc_url( $video_url ); ?>" data-video-thumb="<?php echo esc_url( $video_thumb['src'] ); ?>"></div>
        <?php endif; ?>
    <?php elseif ( $style == 'title' ) : ?>
        <?php
        $video_url = piroll_get_metabox( 'single_portfolio_video_url' );
        $video_thumb = piroll_get_attachment( piroll_get_metabox( 'single_portfolio_video_thumbnail' ), 'piroll_1920x1080' );
        ?>
        <div class="container">
            <div class="nk-portfolio-single">
                <div class="nk-gap-4 mb-14"></div>
                <?php the_title( '<h1 class="nk-portfolio-title text-xs-center">', '</h1>' ); ?>
                <?php
                $subtitle = piroll_get_metabox( 'single_portfolio_subtitle' );

                if ( $subtitle ) :
                    ?>
                    <div class="nk-portfolio-info">
                        <div class="nk-portfolio-text">
                            <div class="lead lead-sm pt-3 text-xs-center"><?php echo wp_kses_post( $subtitle ); ?></div>
                        </div>
                    </div>
                    <div class="nk-gap-4 mt-14"></div>
                <?php endif; ?>
            </div>
        </div>

    <?php else : ?>
        <div class="container-fluid">
            <div class="nk-portfolio-single nk-portfolio-single-half">
                <div class="row">
                    <div class="col-lg-6<?php echo esc_attr( 'half_inverse' === $style ? '' : ' push-lg-6' ); ?>">
                        <div class="nk-sidebar-sticky" data-offset-top="0">
                            <div>
                                <?php piroll_get_portfolio_content( 'half' ); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6<?php echo esc_attr( 'half_inverse' === $style ? '' : ' pull-lg-6' ); ?>">
                        <div class="nk-portfolio-images">
                            <?php
                            if ( $gallery && count( $gallery ) > 0 ) {
                                foreach ( $gallery as $img ) {
                                    $attachment = piroll_get_attachment( $img['ID'], $images_size );
                                    $link = get_post_meta( $img['ID'], 'link', true );
                                    if ( $attachment ) {
                                        if ( $link ) {
                                            echo '<a href="' . esc_url( $link ) . '">';
                                        }
                                        echo '<img src="' . esc_url( $attachment['src'] ) . '" alt="' . ( $attachment['alt'] ? $attachment['alt'] : '' ) . '">';
                                        if ( $link ) {
                                            echo '</a>';
                                        }
                                    }
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php
    if ( $content_position != 'top' && $style != 'half' && $style != 'half_inverse' ) {
        piroll_get_portfolio_content();
    }
    ?>

    <?php if ( piroll_get_metabox( 'single_portfolio_site_show' ) ) : ?>
        <div class="nk-portfolio-launch-site">
            <?php if ( piroll_get_metabox( 'single_portfolio_site_url' ) ) : ?>
                <a href="<?php echo esc_url( piroll_get_metabox( 'single_portfolio_site_url' ) ); ?>"><?php echo esc_html__( 'Launch Site', 'piroll' ); ?></a>
            <?php endif; ?>

            <?php if ( piroll_get_metabox( 'single_portfolio_site_sharing' ) ) : ?>
                <?php
                $arSocial = piroll_get_social_list( 'small' );
                $social_links = piroll_get_theme_mod( 'sharing_links' );
                if ( count( $social_links ) > 0 ) :
                    ?>
                    <div>
                        <em>
                            <?php piroll_sharing_links( $social_links ); ?>
                        </em>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php
    if ( comments_open() || get_comments_number() ) :
        comments_template();
    endif;
    ?>

    <?php
    if ( piroll_get_theme_mod( 'single_portfolio_show_prev_next' ) ) :
        $archive_url = piroll_get_theme_mod( 'single_portfolio_archive_url' );
        $prev_post = get_previous_post();
        $next_post = get_next_post();
        ?>
        <div class="nk-pagination nk-pagination-center">
            <div class="container">
                <?php if ( $prev_post ) : ?>
                    <a class="nk-pagination-prev" href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>">
                        <span class="pe-7s-angle-left"></span> <?php echo esc_html__( 'Previous Work', 'piroll' ); ?>
                    </a>
                <?php else : ?>
                    <span class="nk-pagination-prev"></span>
                <?php endif; ?>

                <?php if ( $archive_url ) : ?>
                    <a class="nk-pagination-center" href="<?php echo esc_url( $archive_url ); ?>">
                        <span class="nk-icon-squares"></span>
                    </a>
                <?php endif; ?>

                <?php if ( $next_post ) : ?>
                    <a class="nk-pagination-next" href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>">
                        <?php echo esc_html__( 'Next Work', 'piroll' ); ?> <span class="pe-7s-angle-right"></span>
                    </a>
                <?php else : ?>
                    <span class="nk-pagination-next"></span>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div>
