<?php
/**
 * @package Piroll
 */
?>
<?php
$post_type = get_post_type();
if ( ! $post_type ) {
    $post_type = 'page';
}
// use acf settings (return true or null)
$acf_header = piroll_get_theme_mod( 'post_header_custom', true );
$acf_content = piroll_get_theme_mod( 'content_post_custom', true );
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="container">
        <div class="row">
            <div class="col-lg-8 offset-lg-2">
                <div class="nk-gap-4"></div>

                <!-- START: Post -->
                <div class="nk-blog-post nk-blog-post-single">
                    <?php global $post; ?>

                    <?php
                    if ( piroll_get_theme_mod( 'single_post_show_title', $acf_content ) ) :
                        the_title( '<h1>', '</h1>' );
                    endif;
                    ?>

                    <div class="nk-post-meta">
                        <?php the_time( esc_html__( 'F j, Y ', 'piroll' ) ); ?>

                        <?php $category = get_the_category(); ?>
                        <?php foreach ( $category as $key => $cat_item ) : ?>
                            / <a href="<?php echo get_category_link( $cat_item->cat_ID ); ?>"><?php echo esc_html( $cat_item->name ); ?></a>
                        <?php endforeach; ?>

                        / <?php echo get_comments_number( $post->ID ); ?> <?php echo esc_html__( 'Comments', 'piroll' ); ?>
                    </div>

                    <!-- START: Post Text -->
                    <div class="nk-post-text">

                        <?php the_content(); ?>

                        <div class="clearfix"></div>

                        <?php
                        wp_link_pages(
                            array(
                                'before'           => '<p><strong class="text-dark-1">' . esc_html__( 'Pages:', 'piroll' ) . '</strong>',
                                'after'            => '</p>',
                                'link_before'      => '',
                                'link_after'       => '',
                                'next_or_number'   => 'number',
                                'separator'        => ' ',
                                'nextpagelink'     => esc_html__( 'Next page', 'piroll' ),
                                'previouspagelink' => esc_html__( 'Previous page', 'piroll' ),
                                'pagelink'         => '%',
                                'echo'             => 1,
                            )
                        );

                        the_tags( '<div class="page-tags"><strong class="text-dark-1">' . esc_html__( 'Tags:', 'piroll' ) . '</strong> ', '', '</div>' );
                        ?>
                    </div>
                    <!-- END: Post Text -->


                    <?php
                    $arSocial = piroll_get_social_list( 'small' );
                    $social_links = piroll_get_theme_mod( 'sharing_links' );
                    if ( count( $social_links ) > 0 ) :
                        ?>
                        <div class="nk-post-share">
                            <strong><?php echo esc_html__( 'Share:', 'piroll' ); ?></strong>
                            <?php piroll_sharing_links( $social_links ); ?>
                        </div>
                    <?php endif; ?>
                </div>
                <!-- END: Post -->

                <div class="nk-gap-3"></div>
            </div>
        </div>
    </div>

    <?php
    if ( comments_open() || get_comments_number() ) :
        comments_template();
    endif;
    ?>

    <?php
    if ( piroll_get_theme_mod( 'single_post_show_prev_next' ) ) {
        $archive_url = piroll_get_theme_mod( 'single_post_archive_url' );
        $prev_post   = get_previous_post();
        $next_post   = get_next_post();

        if ( $archive_url || $prev_post || $next_post ) {
            ?>
            <div class="nk-pagination nk-pagination-center bg-gray-2">
                <div class="container">
                    <?php if ( $prev_post ) : ?>
                        <a class="nk-pagination-prev" href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>">
                            <span class="pe-7s-angle-left"></span> <?php echo esc_html__( 'Previous Post', 'piroll' ); ?>
                        </a>
                    <?php else : ?>
                        <span class="nk-pagination-prev"></span>
                    <?php endif; ?>

                    <?php if ( $archive_url ) : ?>
                        <a class="nk-pagination-center" href="<?php echo esc_url( $archive_url ); ?>">
                            <span class="nk-icon-squares"></span>
                        </a>
                    <?php endif; ?>

                    <?php if ( $next_post ) : ?>
                        <a class="nk-pagination-next" href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>">
                            <?php echo esc_html__( 'Next Post', 'piroll' ); ?> <span class="pe-7s-angle-right"></span>
                        </a>
                    <?php else : ?>
                        <span class="nk-pagination-next"></span>
                    <?php endif; ?>
                </div>
            </div>
            <?php
        }
    }
    ?>
</div>
