<!-- START: Header Title -->
<?php if ( piroll_get_theme_mod( 'archive_header_show', true ) ) : ?>
    <?php
    // define additional classes
    $navbarAdditionalClasses = '';
    if ( piroll_get_theme_mod( 'archive_header_size', true ) ) {
        $navbarAdditionalClasses .= ' nk-header-title-' . piroll_get_theme_mod( 'archive_header_size', true );
    }
    if ( piroll_get_theme_mod( 'archive_header_parallax', true ) ) {
        $navbarAdditionalClasses .= ' nk-header-title-parallax';
    }
    if ( piroll_get_theme_mod( 'archive_header_parallax_opacity', true ) ) {
        $navbarAdditionalClasses .= ' nk-header-title-parallax-opacity';
    }
    $customColor = '';
    if ( piroll_get_theme_mod( 'archive_header_color' ) ) {
        $customColor = 'color: ' . piroll_get_theme_mod( 'archive_header_color' ) . ';';
    }
    ?>
<div
    class="nk-header-title <?php echo esc_attr( $navbarAdditionalClasses ); ?>
">
    <?php if ( piroll_get_theme_mod( 'archive_header_background_image', true ) ) : ?>
        <div class="bg-image">
            <div
                style="background-image: url('<?php echo esc_url( piroll_get_theme_mod( 'archive_header_background_image', true ) ); ?>');"
                <?php echo piroll_get_theme_mod( 'archive_header_background_image_opacity', true ) ? 'class ="' . esc_attr( 'op-' . piroll_get_theme_mod( 'archive_header_background_image_opacity', true ) ) . '"' : ''; ?>></div>
            <div class="bg-image-overlay" style="background-color: <?php echo esc_attr( piroll_get_theme_mod( 'archive_header_overlay' ) ); ?>;"></div>
        </div>
    <?php else : ?>
        <div class="bg-image">
            <div class="bg-image-overlay" style="background-color: <?php echo esc_attr( piroll_get_theme_mod( 'archive_header_overlay' ) ); ?>;"></div>
        </div>
    <?php endif; ?>

    <div class="nk-header-table">
        <div class="nk-header-table-cell">
            <div class="container">
                <?php
                $archive_header_sub_title_show = piroll_get_theme_mod( 'archive_header_sub_title_show', true );
                $archive_header_content = piroll_get_theme_mod( 'archive_header_content', true );
                $archive_header_video_link = piroll_get_theme_mod( 'archive_header_video_link', true );
                ?>

                <?php if ( ! empty( $archive_header_sub_title_show ) ) : ?>
                    <h2 class="nk-subtitle" style="<?php echo esc_attr( $customColor ); ?>"><?php echo esc_attr( piroll_get_theme_mod( 'archive_header_sub_title', true ) ); ?></h2>
                <?php endif; ?>

                <?php if ( piroll_get_theme_mod( 'archive_show_title', true ) ) : ?>
                    <?php
                    if ( is_front_page() ) {
                        echo '<h1 class="nk-title" style="' . esc_attr( $customColor ) . '">';
                        echo wp_get_document_title();
                        echo '</h1>';
                    } else {
                        the_archive_title( '<h1 class="nk-title" style="' . esc_attr( $customColor ) . '">', '</h1>' );
                    }
                    ?>
                <?php endif; ?>

                <?php if ( ! empty( $archive_header_content ) ) : ?>
                    <div class="nk-gap"></div>
                    <div style="<?php echo esc_attr( $customColor ); ?>">
                        <?php
                        echo do_shortcode( piroll_get_theme_mod( 'archive_header_content', true ) );
                        ?>
                    </div>
                <?php endif; ?>
                <?php if ( ! empty( $archive_header_video_link ) ) : ?>
                    <div class="nk-gap-2"></div>
                    <a class="nk-video-fullscreen-toggle"
                       href="<?php echo esc_url( piroll_get_theme_mod( 'archive_header_video_link', true ) ); ?>">
                        <span class="nk-video-icon"><span><span class="nk-play-icon"></span></span></span>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php
    if ( piroll_get_theme_mod( 'archive_header_scroll_down_button', true ) ) {
        ?>
        <div><a class="nk-header-title-scroll-down" href="#nk-header-title-scroll-down" style="<?php echo esc_attr( $customColor ); ?>"><span class="pe-7s-angle-down"></span></a></div>
        <?php
    }
    ?>
</div>
<div id="nk-header-title-scroll-down"></div>
<?php endif; ?>
<!-- END: Header Title -->
