<!-- START: Header Title -->
<?php
// use acf settings (return true or null)
$acf_header = piroll_get_theme_mod( 'post_header_custom', true );
$acf_content = piroll_get_theme_mod( 'content_post_custom', true );
global $post;
?>
<?php if ( piroll_get_theme_mod( 'single_post_header_show', $acf_header ) ) : ?>
    <?php
    // define additional classes
    $additionalClasses = '';
    if ( piroll_get_theme_mod( 'single_post_header_size', $acf_header ) ) {
        $additionalClasses .= ' nk-header-title-' . piroll_get_theme_mod( 'single_post_header_size', $acf_header );
    }
    if ( piroll_get_theme_mod( 'single_post_header_parallax', $acf_header ) ) {
        $additionalClasses .= ' nk-header-title-parallax';
    }
    if ( piroll_get_theme_mod( 'single_post_header_parallax_opacity', $acf_header ) ) {
        $additionalClasses .= ' nk-header-title-parallax-opacity';
    }
    $customColor = '';
    if ( piroll_get_theme_mod( 'single_post_header_color', $acf_header ) ) {
        $customColor = 'color: ' . piroll_get_theme_mod( 'single_post_header_color', $acf_header ) . ';';
    }
    ?>
    <div
        class="nk-header-title<?php echo esc_attr( $additionalClasses ); ?>">
        <?php
        $banner_url = '';
        ?>
        <?php if ( piroll_get_theme_mod( 'single_post_header_type_image', $acf_header ) ) : ?>
            <?php
            if ( piroll_get_theme_mod( 'single_post_header_type_image', $acf_header ) == 'custom' ) {
                $banner_url = piroll_get_theme_mod( 'single_post_header_background_image', $acf_header );
            } elseif ( piroll_get_theme_mod( 'single_post_header_type_image', $acf_header ) == 'featured' ) {
                $attachment = piroll_get_attachment( get_post_thumbnail_id( $post->ID ) );
                $banner_url = $attachment['src'];
            }
            ?>
            <?php if ( isset( $banner_url ) ) : ?>
                <div class="bg-image">
                    <div
                        style="background-image: url('<?php echo esc_url( $banner_url ); ?>');"
                        <?php echo piroll_get_theme_mod( 'single_post_header_background_image_opacity', $acf_header ) ? 'class ="' . esc_attr( 'op-' . piroll_get_theme_mod( 'single_post_header_background_image_opacity', $acf_header ) ) . '"' : ''; ?>></div>
                    <div class="bg-image-overlay" style="background-color: <?php echo esc_attr( piroll_get_theme_mod( 'single_post_header_overlay', $acf_header ) ); ?>;"></div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
        <?php if ( ! $banner_url ) : ?>
            <div class="bg-image">
                <div class="bg-image-overlay" style="background-color: <?php echo esc_attr( piroll_get_theme_mod( 'single_post_header_overlay', $acf_header ) ); ?>;"></div>
            </div>
        <?php endif; ?>

        <div class="nk-header-table">
            <div class="nk-header-table-cell">
                <div class="container">
                    <?php
                    $header_sub_title = piroll_get_theme_mod( 'single_post_header_sub_title', $acf_header );
                    $header_content = piroll_get_theme_mod( 'single_post_header_content', $acf_header );
                    $header_video_link = piroll_get_theme_mod( 'single_post_header_video_link', $acf_header );
                    ?>

                    <?php if ( ! empty( $header_sub_title ) ) : ?>
                        <h2 class="nk-subtitle" style="<?php echo esc_attr( $customColor ); ?>"><?php echo esc_attr( $header_sub_title ); ?></h2>
                    <?php endif; ?>

                    <?php if ( piroll_get_theme_mod( 'single_post_header_title_type', $acf_header ) == 'title' ) : ?>
                        <h1 class="nk-title" style="<?php echo esc_attr( $customColor ); ?>"><?php single_post_title(); ?></h1>
                    <?php elseif ( piroll_get_theme_mod( 'single_post_header_title_type', $acf_header ) == 'custom' ) : ?>
                        <h1 class="nk-title" style="<?php echo esc_attr( $customColor ); ?>"><?php echo wp_kses_post( piroll_get_theme_mod( 'single_post_header_title', $acf_header ) ); ?></h1>
                    <?php endif; ?>

                    <?php if ( ! empty( $header_content ) ) : ?>
                        <div class="nk-gap"></div>
                        <div style="<?php echo esc_attr( $customColor ); ?>">
                            <?php
                            echo do_shortcode( $header_content );
                            ?>
                        </div>
                    <?php endif; ?>

                    <?php if ( ! empty( $header_video_link ) ) : ?>
                        <div class="nk-gap-2"></div>
                        <a class="nk-video-fullscreen-toggle"
                           href="<?php echo esc_url( $header_video_link ); ?>">
                            <span class="nk-video-icon"><span><span class="nk-play-icon"></span></span></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php
        if ( piroll_get_theme_mod( 'single_post_header_scroll_down_button', $acf_header ) ) {
            ?>
            <div><a class="nk-header-title-scroll-down" href="#nk-header-title-scroll-down" style="<?php echo esc_attr( $customColor ); ?>"><span class="pe-7s-angle-down"></span></a></div>
            <?php
        }
        ?>
    </div>
    <div id="nk-header-title-scroll-down"></div>
<?php endif; ?>
<!-- END: Header Title -->
