<?php
/**
 * Item meta template.
 *
 * @var $args
 * @var $opts
 * @package visual-portfolio
 */

?>

<div class="vp-portfolio__item-overlay vp-portfolio__item-align-<?php echo esc_attr( $opts['align'] ); ?>">
    <div class="vp-portfolio__item-meta">
        <?php

        // Show Title.
        if ( $opts['show_title'] && $args['title'] ) {
            ?>
            <h2 class="nk-post-title h5">
                <?php
                if ( $args['url'] ) {
                    ?>
                    <a href="<?php echo esc_url( $args['url'] ); ?>">
                        <?php echo esc_html( $args['title'] ); ?>
                    </a>
                    <?php
                } else {
                    echo esc_html( $args['title'] );
                }
                ?>
            </h2>
            <?php
        }

        $show_date = $opts['show_date'] && $args['published'];
        $show_cats = $opts['show_categories'] && $args['categories'] && ! empty( $args['categories'] );
        if ( $show_date || $show_cats ) {
            ?>
            <div class="nk-post-meta">
                <?php
                // Show Date.
                if ( $show_date ) {
                    echo esc_html( $args['published'] );
                    if ( $show_cats ) {
                        echo ' / ';
                    }
                }

                // Show Categories.
                if ( $show_cats ) {
                    $count = $opts['categories_count'];
                    foreach ( $args['categories'] as $category ) {
                        if ( ! $count ) {
                            break;
                        }
                        ?>
                        <a href="<?php echo esc_html( $category['url'] ); ?>">
                            <?php echo esc_html( $category['label'] ); ?>
                        </a>
                        <?php
                        $count--;
                    }
                }
                ?>
            </div>
            <?php
        }

        // Show Excerpt.
        if ( $opts['show_excerpt'] && $args['excerpt'] ) {
            ?>
            <div class="nk-post-text">
                <?php echo esc_html( $args['excerpt'] ); ?>
            </div>
            <?php
        }
        ?>
    </div>
</div>
